/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class TemporalConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Date.class.isAssignableFrom(source)) {
            if (Calendar.class.isAssignableFrom(target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime((Date)source);
                        return calendar;
                    }
                };
            }
            if (Timestamp.class.isAssignableFrom(target) || Time.class.isAssignableFrom(target) || java.sql.Date.class.isAssignableFrom(target)) {
                return new Converter(){

                    public Object convert(Object source, Class target) throws Exception {
                        Date date = (Date)source;
                        return target.getConstructor(Long.TYPE).newInstance(new Long(date.getTime()));
                    }
                };
            }
        }
        if (Calendar.class.isAssignableFrom(source) && Date.class.isAssignableFrom(target)) {
            Class fTarget = target;
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    Calendar calendar = (Calendar)source;
                    return target.getConstructor(Long.TYPE).newInstance(new Long(calendar.getTimeInMillis()));
                }
            };
        }
        return null;
    }
}

