/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.resources.Utilities;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.StyleVisitor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.Cloneable;

public class PointPlacementImpl
extends AbstractGTComponent
implements PointPlacement,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private final FilterFactory filterFactory;
    private AnchorPoint anchorPoint = new AnchorPointImpl();
    private Displacement displacement = new DisplacementImpl();
    private Expression rotation = null;

    public PointPlacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public PointPlacementImpl(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.rotation = this.filterFactory.literal((Object)new Integer(0));
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultPointPlacement: " + (Object)((Object)ife));
        }
    }

    public AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorPoint(AnchorPoint anchorPoint) {
        this.anchorPoint = anchorPoint == null ? new AnchorPointImpl() : anchorPoint;
        this.fireChanged();
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(Displacement displacement) {
        this.displacement = displacement == null ? new DisplacementImpl() : displacement;
        this.fireChanged();
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
        this.fireChanged();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((PointPlacement)this);
    }

    public Object clone() {
        try {
            PointPlacementImpl clone = (PointPlacementImpl)super.clone();
            clone.anchorPoint = (AnchorPoint)((Cloneable)this.anchorPoint).clone();
            clone.displacement = (Displacement)((Cloneable)this.displacement).clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PointPlacementImpl) {
            PointPlacementImpl other = (PointPlacementImpl)obj;
            return Utilities.equals((Object)this.anchorPoint, (Object)other.anchorPoint) && Utilities.equals((Object)this.displacement, (Object)other.displacement) && Utilities.equals((Object)this.rotation, (Object)other.rotation);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.anchorPoint != null) {
            result = result * 37 + this.anchorPoint.hashCode();
        }
        if (this.displacement != null) {
            result = result * 37 + this.displacement.hashCode();
        }
        if (this.rotation != null) {
            result = result * 37 + this.rotation.hashCode();
        }
        return result;
    }
}

