/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.event.AbstractGTComponent;
import org.geotools.event.GTList;
import org.geotools.resources.Utilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.opengis.util.Cloneable;

public class FeatureTypeStyleImpl
extends AbstractGTComponent
implements FeatureTypeStyle,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.styling");
    private List ruleList = new GTList(this, "rules");
    private String featureTypeName = "Feature";
    private String name = "name";
    private String title = "title";
    private String abstractStr = "abstract";
    private String[] semanticTypeIdentifiers;

    protected FeatureTypeStyleImpl(Rule[] rules) {
        this(Arrays.asList(rules));
    }

    protected FeatureTypeStyleImpl(List rules) {
        this.ruleList.addAll(rules);
    }

    protected FeatureTypeStyleImpl() {
    }

    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public Rule[] getRules() {
        return this.ruleList.toArray(new Rule[0]);
    }

    public List rules() {
        return this.ruleList;
    }

    public String[] getSemanticTypeIdentifiers() {
        if (this.semanticTypeIdentifiers == null) {
            return new String[]{"generic:geometry"};
        }
        return this.semanticTypeIdentifiers;
    }

    public void setSemanticTypeIdentifiers(String[] types) {
        this.semanticTypeIdentifiers = types;
    }

    public void setRules(Rule[] rules) {
        this.ruleList.clear();
        this.ruleList.addAll(Arrays.asList(rules));
    }

    public void addRule(Rule rule) {
        this.ruleList.add(rule);
    }

    public void setFeatureTypeName(String name) {
        if (name.equals("feature")) {
            LOGGER.warning("FeatureTypeStyle with typename 'feature' - you probably meant to say 'Feature' (capital F) for the 'generic' FeatureType");
        }
        this.featureTypeName = name;
        this.fireChanged();
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
        this.fireChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireChanged();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((FeatureTypeStyle)this);
    }

    public Object clone() {
        FeatureTypeStyle clone;
        try {
            clone = (FeatureTypeStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        Rule[] ruleArray = new Rule[this.ruleList.size()];
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule = (Rule)this.ruleList.get(i);
            ruleArray[i] = (Rule)((Cloneable)rule).clone();
        }
        clone.setRules(ruleArray);
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.ruleList != null) {
            result = 1000003 * result + ((Object)this.ruleList).hashCode();
        }
        if (this.featureTypeName != null) {
            result = 1000003 * result + this.featureTypeName.hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        if (this.abstractStr != null) {
            result = 1000003 * result + this.abstractStr.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FeatureTypeStyleImpl) {
            FeatureTypeStyleImpl other = (FeatureTypeStyleImpl)oth;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.title, (Object)other.title) && Utilities.equals((Object)this.abstractStr, (Object)other.abstractStr) && Utilities.equals((Object)this.featureTypeName, (Object)other.featureTypeName) && Utilities.equals((Object)this.ruleList, (Object)other.ruleList);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FeatureTypeStyleImpl<");
        buf.append(this.notification);
        buf.append(">");
        buf.append("[");
        if (this.name != null) {
            buf.append(" name=");
            buf.append(this.name);
        } else {
            buf.append(" UNNAMED");
        }
        buf.append(", ");
        buf.append(this.featureTypeName);
        buf.append(", rules=<");
        buf.append(this.ruleList.size());
        buf.append(">");
        if (this.ruleList.size() > 0) {
            buf.append("(");
            buf.append(this.ruleList.get(0));
            if (this.ruleList.size() > 1) {
                buf.append(",...");
            }
            buf.append(")");
        }
        buf.append("]");
        return buf.toString();
    }
}

