/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.logging.Level;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.filter.expression.Expression;

public class StandardDeviationFunction
extends ClassificationFunction {
    public int getArgCount() {
        return 2;
    }

    public StandardDeviationFunction() {
        this.setName("StandardDeviation");
    }

    private Object calculate(FeatureCollection featureCollection) {
        try {
            int classNum = this.getClasses();
            AverageVisitor averageVisit = new AverageVisitor((Expression)this.getExpression());
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            featureCollection.accepts((FeatureVisitor)averageVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            CalcResult calcResult = averageVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            double average = calcResult.toDouble();
            StandardDeviationVisitor sdVisit = new StandardDeviationVisitor((Expression)this.getExpression(), average);
            featureCollection.accepts((FeatureVisitor)sdVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            calcResult = sdVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            double standardDeviation = calcResult.toDouble();
            Comparable[] min = new Double[classNum];
            Comparable[] max = new Double[classNum];
            for (int i = 0; i < classNum; ++i) {
                min[i] = this.getMin(i, classNum, average, standardDeviation);
                max[i] = this.getMax(i, classNum, average, standardDeviation);
            }
            return new RangedClassifier(min, max);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "StandardDeviationFunction calculate failed", e);
            return null;
        }
    }

    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((FeatureCollection)feature);
    }

    private Double getMin(int index, int numClasses, double average, double standardDeviation) {
        if (index <= 0 || index >= numClasses) {
            return null;
        }
        return new Double(average - ((double)numClasses / 2.0 - (double)index) * standardDeviation);
    }

    private Double getMax(int index, int numClasses, double average, double standardDeviation) {
        if (index < 0 || index >= numClasses - 1) {
            return null;
        }
        return new Double(average - ((double)numClasses / 2.0 - 1.0 - (double)index) * standardDeviation);
    }
}

