/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import com.vividsolutions.jts.geom.Geometry;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;

public class SimpleFeaturePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor ATTRIBUTE_ACCESS = new SimpleFeaturePropertyAccessor();
    static PropertyAccessor DEFAULT_GEOMETRY_ACCESS = new DefaultGeometrySimpleFeaturePropertyAccessor();
    static PropertyAccessor FID_ACCESS = new FidSimpleFeaturePropertyAccessor();
    static Pattern idPattern = Pattern.compile("@(\\w+:)?id");
    static Pattern propertyPattern = Pattern.compile("(\\w+:)?(\\w+)");

    public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
        if (xpath == null) {
            return null;
        }
        if (!Feature.class.isAssignableFrom(type) && !FeatureType.class.isAssignableFrom(type)) {
            return null;
        }
        if ("".equals(xpath)) {
            return DEFAULT_GEOMETRY_ACCESS;
        }
        if (idPattern.matcher(xpath).matches()) {
            return FID_ACCESS;
        }
        if (propertyPattern.matcher(xpath).matches()) {
            return ATTRIBUTE_ACCESS;
        }
        return null;
    }

    static String stripPrefix(String xpath) {
        int split = xpath.indexOf(":");
        if (split != -1) {
            return xpath.substring(split + 1);
        }
        return xpath;
    }

    static class SimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        SimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof Feature) {
                return ((Feature)object).getAttribute(xpath) != null;
            }
            if (object instanceof FeatureType) {
                return ((FeatureType)object).getAttributeType(xpath) != null;
            }
            return false;
        }

        public Object get(Object object, String xpath, Class target) {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof Feature) {
                return ((Feature)object).getAttribute(xpath);
            }
            if (object instanceof FeatureType) {
                return ((FeatureType)object).getAttributeType(xpath);
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            xpath = SimpleFeaturePropertyAccessorFactory.stripPrefix(xpath);
            if (object instanceof Feature) {
                ((Feature)object).setAttribute(xpath, value);
            }
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class DefaultGeometrySimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        DefaultGeometrySimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            if (!"".equals(xpath)) {
                return false;
            }
            return object instanceof Feature || object instanceof FeatureType;
        }

        public Object get(Object object, String xpath, Class target) {
            if (object instanceof Feature) {
                return ((Feature)object).getPrimaryGeometry();
            }
            if (object instanceof FeatureType) {
                return ((FeatureType)object).getPrimaryGeometry();
            }
            return null;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            if (object instanceof Feature) {
                ((Feature)object).setPrimaryGeometry((Geometry)value);
            }
            if (object instanceof FeatureType) {
                throw new IllegalAttributeException("feature type is immutable");
            }
        }
    }

    static class FidSimpleFeaturePropertyAccessor
    implements PropertyAccessor {
        FidSimpleFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof Feature && xpath.matches("@(\\w+:)?id");
        }

        public Object get(Object object, String xpath, Class target) {
            Feature feature = (Feature)object;
            return feature.getID();
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            throw new IllegalAttributeException("feature id is immutable");
        }
    }
}

