/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FunctionExpression;

class FilterNameTypeMapping {
    static Map spatialFiltersMap = FilterNameTypeMapping.loadSpatialFiltersMap();
    static Map comparisonsMap = FilterNameTypeMapping.loadComparisonFilterMap();
    static Map filterTypeToFilterCapabilitiesMap = FilterNameTypeMapping.loadFilterTypeToFilterCapabilitiesMap();
    static Map functionNameMap = FilterNameTypeMapping.loadFunctionNameMap();
    static final FilterCapabilities NO_OP_CAPS = new FilterCapabilities(0L);
    public static final FilterCapabilities ALL_CAPS = new FilterCapabilities(){

        public boolean supports(Class type) {
            return super.supports(type);
        }

        public boolean supports(Filter filter) {
            return true;
        }

        public boolean supports(FilterCapabilities type) {
            return true;
        }

        public boolean supports(long type) {
            return true;
        }

        public boolean supports(short type) {
            return true;
        }
    };

    FilterNameTypeMapping() {
    }

    public static Map loadSpatialFiltersMap() {
        spatialFiltersMap = new HashMap();
        spatialFiltersMap.put("", NO_OP_CAPS);
        spatialFiltersMap.put("BBOX", new FilterCapabilities(1L));
        spatialFiltersMap.put("Equals", new FilterCapabilities(2L));
        spatialFiltersMap.put("Disjoint", new FilterCapabilities(4L));
        spatialFiltersMap.put("Intersect", new FilterCapabilities(8L));
        spatialFiltersMap.put("Touches", new FilterCapabilities(16L));
        spatialFiltersMap.put("Crosses", new FilterCapabilities(32L));
        spatialFiltersMap.put("Within", new FilterCapabilities(64L));
        spatialFiltersMap.put("Contains", new FilterCapabilities(128L));
        spatialFiltersMap.put("Overlaps", new FilterCapabilities(256L));
        spatialFiltersMap.put("Beyond", new FilterCapabilities(512L));
        spatialFiltersMap.put("DWithin", new FilterCapabilities(1024L));
        return spatialFiltersMap;
    }

    public static Map loadComparisonFilterMap() {
        comparisonsMap = new HashMap();
        comparisonsMap.put("", NO_OP_CAPS);
        comparisonsMap.put("Logical", new FilterCapabilities(0x3800000L));
        comparisonsMap.put("Simple_Comparisons", new FilterCapabilities(0x3F0000L));
        comparisonsMap.put("Like", new FilterCapabilities(2048L));
        comparisonsMap.put("Between", new FilterCapabilities(4096L));
        comparisonsMap.put("NullCheck", new FilterCapabilities(8192L));
        comparisonsMap.put("Simple_Arithmetic", new FilterCapabilities(16384L));
        comparisonsMap.put("Functions", new FilterCapabilities(32768L));
        return comparisonsMap;
    }

    public static Map loadFilterTypeToFilterCapabilitiesMap() {
        HashMap<Short, FilterCapabilities> conversionMap = new HashMap<Short, FilterCapabilities>();
        conversionMap.put(new Short(19), new FilterCapabilities(4096L));
        conversionMap.put(new Short(14), new FilterCapabilities(65536L));
        conversionMap.put(new Short(16), new FilterCapabilities(131072L));
        conversionMap.put(new Short(18), new FilterCapabilities(262144L));
        conversionMap.put(new Short(15), new FilterCapabilities(524288L));
        conversionMap.put(new Short(17), new FilterCapabilities(0x100000L));
        conversionMap.put(new Short(23), new FilterCapabilities(0x200000L));
        conversionMap.put(new Short(22), new FilterCapabilities(0x400000L));
        conversionMap.put(new Short(4), new FilterCapabilities(1L));
        conversionMap.put(new Short(13), new FilterCapabilities(512L));
        conversionMap.put(new Short(11), new FilterCapabilities(128L));
        conversionMap.put(new Short(9), new FilterCapabilities(32L));
        conversionMap.put(new Short(6), new FilterCapabilities(4L));
        conversionMap.put(new Short(24), new FilterCapabilities(1024L));
        conversionMap.put(new Short(5), new FilterCapabilities(2L));
        conversionMap.put(new Short(7), new FilterCapabilities(8L));
        conversionMap.put(new Short(12), new FilterCapabilities(256L));
        conversionMap.put(new Short(8), new FilterCapabilities(16L));
        conversionMap.put(new Short(10), new FilterCapabilities(64L));
        conversionMap.put(new Short(20), new FilterCapabilities(2048L));
        conversionMap.put(new Short(2), new FilterCapabilities(0x800000L));
        conversionMap.put(new Short(3), new FilterCapabilities(0x1000000L));
        conversionMap.put(new Short(1), new FilterCapabilities(0x2000000L));
        conversionMap.put(new Short(21), new FilterCapabilities(8192L));
        return conversionMap;
    }

    public static Map loadFunctionNameMap() {
        functionNameMap = new HashMap();
        functionNameMap.put("", NO_OP_CAPS);
        for (FunctionExpression exp : CommonFactoryFinder.getFunctionExpressions(null)) {
            functionNameMap.put(exp.getName().toLowerCase(), new FilterCapabilities(exp.getClass()));
        }
        return functionNameMap;
    }

    public static FilterCapabilities findFunction(String name) {
        FilterCapabilities filterCapabilities = (FilterCapabilities)functionNameMap.get(name);
        if (filterCapabilities != null) {
            return filterCapabilities;
        }
        return NO_OP_CAPS;
    }

    public static FilterCapabilities findOperation(String s) {
        if (spatialFiltersMap.containsKey(s)) {
            return (FilterCapabilities)spatialFiltersMap.get(s);
        }
        if (comparisonsMap.containsKey(s)) {
            return (FilterCapabilities)comparisonsMap.get(s);
        }
        return NO_OP_CAPS;
    }

    public static String writeSpatialOperation(long i) {
        if (i == 1L) {
            return "BBOX";
        }
        if (i == 2L) {
            return "Equals";
        }
        if (i == 4L) {
            return "Disjoint";
        }
        if (i == 8L) {
            return "Intersect";
        }
        if (i == 16L) {
            return "Touches";
        }
        if (i == 32L) {
            return "Crosses";
        }
        if (i == 64L) {
            return "Within";
        }
        if (i == 128L) {
            return "Contains";
        }
        if (i == 256L) {
            return "Overlaps";
        }
        if (i == 512L) {
            return "Beyond";
        }
        if (i == 1024L) {
            return "DWithin";
        }
        return "";
    }

    public static String writeScalarOperation(long i) {
        if (i == 0x3800000L) {
            return "Logical";
        }
        if (i == 0x3F0000L) {
            return "Simple_Comparisons";
        }
        if (i == 2048L) {
            return "Like";
        }
        if (i == 4096L) {
            return "Between";
        }
        if (i == 8192L) {
            return "NullCheck";
        }
        if (i == 16384L) {
            return "Simple_Arithmetic";
        }
        if (i == 32768L) {
            return "Functions";
        }
        if (i == 0x400000L) {
            return "FeatureID";
        }
        if (i == 65536L) {
            return "Compare_Equals";
        }
        if (i == 131072L) {
            return "Compare_Greater_Than";
        }
        if (i == 262144L) {
            return "Compare_Greater_Than_Equal";
        }
        if (i == 524288L) {
            return "Compare_Less_Than";
        }
        if (i == 0x100000L) {
            return "Compare_Less_Than_Equal";
        }
        if (i == 0x200000L) {
            return "Compare_Not_Equals";
        }
        return "";
    }
}

