/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.Set;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.resources.Utilities;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class FeatureTypeImpl
extends ComplexTypeImpl
implements FeatureType {
    protected AttributeDescriptor DEFAULT;
    protected CoordinateReferenceSystem CRS;

    public FeatureTypeImpl(Name name, Collection schema, AttributeDescriptor defaultGeom, CoordinateReferenceSystem crs, boolean isAbstract, Set restrictions, AttributeType superType, InternationalString description) {
        super(name, schema, true, isAbstract, restrictions, superType, description);
        this.DEFAULT = defaultGeom;
        this.CRS = crs;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.CRS;
    }

    public AttributeDescriptor getDefaultGeometry() {
        if (this.DEFAULT == null) {
            for (AttributeDescriptor desc : this.attributes()) {
                if (!(desc.getType() instanceof GeometryType)) continue;
                this.DEFAULT = desc;
                break;
            }
        }
        return this.DEFAULT;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FeatureType other = (FeatureType)o;
        if (!Utilities.equals((Object)this.DEFAULT, (Object)other.getDefaultGeometry())) {
            return false;
        }
        return Utilities.equals((Object)this.CRS, (Object)other.getCRS());
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.DEFAULT != null) {
            hashCode ^= this.DEFAULT.hashCode();
        }
        if (this.CRS != null) {
            hashCode ^= this.CRS.hashCode();
        }
        return hashCode;
    }
}

