/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.Name;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.opengis.filter.Filter;

public class FeatureAttributeType
extends AttributeDescriptorImpl
implements AttributeType {
    private final FeatureType featureType;

    public FeatureAttributeType(FeatureAttributeType copy) {
        super(copy.getType(), copy.getName(), copy.getMinOccurs(), copy.getMaxOccurs(), copy.isNillable(), copy.getDefaultValue());
        this.featureType = copy.getFeatureType();
    }

    public FeatureAttributeType(String name, FeatureType featureType, boolean nillable, int min, int max) {
        super(DefaultAttributeType.createAttributeType(name, Feature.class, (Filter)Filter.INCLUDE), (org.opengis.feature.type.Name)new Name(name), min, max, nillable, null);
        this.featureType = featureType;
    }

    public FeatureAttributeType(String name, FeatureType featureType, boolean nillable) {
        this(name, featureType, nillable, 1, 1);
    }

    public Filter getRestriction() {
        return DefaultAttributeType.getRestriction(this);
    }

    protected FeatureType getFeatureType() {
        return this.featureType;
    }

    public String getLocalName() {
        return DefaultAttributeType.getLocalName(this);
    }

    public Class getBinding() {
        return DefaultAttributeType.getBinding(this);
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value instanceof Feature) {
            return value;
        }
        if (value instanceof Object[]) {
            try {
                return this.featureType.create((Object[])value);
            }
            catch (IllegalAttributeException e) {
                IllegalArgumentException ee = new IllegalArgumentException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
        }
        throw new IllegalArgumentException(this.getLocalName() + " needs to parse an array of Objects");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        if (obj instanceof Feature) {
            try {
                this.featureType.duplicate((Feature)obj);
                return;
            }
            catch (IllegalAttributeException e) {
                IllegalArgumentException ee = new IllegalArgumentException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
        }
        throw new IllegalArgumentException("Not a Feature");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src instanceof Feature) {
            return this.featureType.duplicate((Feature)src);
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object createDefaultValue() {
        Object[] t = new Object[this.featureType.getAttributeCount()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = null;
        }
        try {
            return this.featureType.create(t);
        }
        catch (IllegalAttributeException e) {
            return null;
        }
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public AttributeType getAttributeType(String xPath) {
        return this.featureType.getAttributeType(xPath);
    }

    public int find(AttributeType type) {
        return this.featureType.find(type);
    }

    public int find(String attName) {
        return this.featureType.find(attName);
    }

    public AttributeType getAttributeType(int position) {
        return this.featureType.getAttributeType(position);
    }

    public AttributeType[] getAttributeTypes() {
        return this.featureType.getAttributeTypes();
    }
}

