/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleSchema;
import org.geotools.feature.simple.SimpleTypeFactoryImpl;
import org.geotools.feature.type.TypeName;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.simple.SimpleTypeFactory;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeBuilder {
    protected SimpleTypeFactory factory;
    protected Map bindings;
    protected String local;
    protected String uri;
    protected InternationalString description;
    protected List attributes;
    protected Set restrictions;
    protected String defaultGeometry;
    protected CoordinateReferenceSystem crs;
    protected boolean isAbstract = false;
    protected SimpleFeatureType superType;
    protected AttributeTypeBuilder attributeBuilder;

    public SimpleFeatureTypeBuilder() {
        this(new SimpleTypeFactoryImpl());
    }

    public SimpleFeatureTypeBuilder(SimpleTypeFactory factory) {
        this.factory = factory;
        this.attributeBuilder = new AttributeTypeBuilder();
        this.setBindings(new SimpleSchema());
    }

    public void setSimpleTypeFactory(SimpleTypeFactory factory) {
        this.factory = factory;
    }

    public SimpleTypeFactory getSimpleTypeFactory() {
        return this.factory;
    }

    public void init(SimpleFeatureType type) {
        this.init();
        if (type == null) {
            return;
        }
        this.uri = type.getName().getNamespaceURI();
        this.local = type.getName().getLocalPart();
        this.description = type.getDescription();
        this.restrictions = null;
        this.restrictions().addAll(type.getRestrictions());
        this.attributes = null;
        this.attributes().addAll(type.attributes());
        this.isAbstract = type.isAbstract();
        this.superType = (SimpleFeatureType)type.getSuper();
    }

    protected void init() {
        this.attributes = null;
    }

    protected void reset() {
        this.uri = null;
        this.local = null;
        this.description = null;
        this.restrictions = null;
        this.attributes = null;
        this.crs = null;
        this.isAbstract = false;
        this.superType = null;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.uri = namespaceURI;
    }

    public void setNamespaceURI(URI namespaceURI) {
        if (namespaceURI != null) {
            this.setNamespaceURI(namespaceURI.toString());
        } else {
            this.setNamespaceURI((String)null);
        }
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public SimpleFeatureTypeBuilder namespaceURI(String namespaceURI) {
        this.setNamespaceURI(namespaceURI);
        return this;
    }

    public void setName(String name) {
        this.local = name;
    }

    public String getName() {
        return this.local;
    }

    public void setDescription(InternationalString description) {
        this.description = description;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public void setDefaultGeometry(String defaultGeometryName) {
        this.defaultGeometry = defaultGeometryName;
    }

    public String getDefaultGeometry() {
        if (this.defaultGeometry == null) {
            for (AttributeDescriptor att : this.attributes()) {
                if (!(att.getType() instanceof GeometryType)) continue;
                return att.getName().getLocalPart();
            }
            return null;
        }
        return this.defaultGeometry;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setSRS(String SRS) {
        try {
            this.setCRS(CRS.decode((String)SRS));
        }
        catch (Exception e) {
            String msg = "SRS '" + SRS + "' unknown:" + e.getLocalizedMessage();
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setSuperType(SimpleFeatureType superType) {
        this.superType = superType;
    }

    public SimpleFeatureType getSuperType() {
        return this.superType;
    }

    public void addBinding(AttributeType type) {
        this.bindings().put(type.getBinding(), type);
    }

    public void addBindings(Schema schema) {
        for (AttributeType type : schema.values()) {
            this.addBinding(type);
        }
    }

    public void setBindings(Schema schema) {
        this.bindings().clear();
        this.addBindings(schema);
    }

    public AttributeType getBinding(Class binding) {
        return (AttributeType)this.bindings().get(binding);
    }

    public SimpleFeatureTypeBuilder minOccurs(int minOccurs) {
        this.attributeBuilder.setMinOccurs(minOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder maxOccurs(int maxOccurs) {
        this.attributeBuilder.setMaxOccurs(maxOccurs);
        return this;
    }

    public SimpleFeatureTypeBuilder nillable(boolean isNillable) {
        this.attributeBuilder.setNillable(isNillable);
        return this;
    }

    public SimpleFeatureTypeBuilder restriction(Filter filter) {
        this.attributeBuilder.addRestriction(filter);
        return this;
    }

    public SimpleFeatureTypeBuilder description(String description) {
        this.attributeBuilder.setDescription(description);
        return this;
    }

    public SimpleFeatureTypeBuilder defaultValue(Object defaultValue) {
        this.attributeBuilder.setDefaultValue(defaultValue);
        return this;
    }

    public SimpleFeatureTypeBuilder crs(CoordinateReferenceSystem crs) {
        this.attributeBuilder.setCRS(crs);
        return this;
    }

    public void add(String name, Class binding) {
        if (this.defaultGeometry != null && this.defaultGeometry.equals(name)) {
            this.add(name, binding, null);
            return;
        }
        this.attributeBuilder.setBinding(binding);
        this.attributeBuilder.setName(name);
        AttributeType type = this.attributeBuilder.buildType();
        AttributeDescriptor descriptor = this.attributeBuilder.buildDescriptor(name, type);
        this.attributes().add(descriptor);
    }

    public void add(String name, Class binding, CoordinateReferenceSystem crs) {
        this.attributeBuilder.setBinding(binding);
        this.attributeBuilder.setName(name);
        this.attributeBuilder.setCRS(crs);
        GeometryType type = this.attributeBuilder.buildGeometryType();
        AttributeDescriptor descriptor = this.attributeBuilder.buildDescriptor(name, (AttributeType)type);
        this.attributes().add(descriptor);
    }

    public SimpleFeatureType buildFeatureType() {
        CoordinateReferenceSystem crs;
        AttributeDescriptor defaultGeometry = null;
        if (this.defaultGeometry != null) {
            List atts = this.attributes();
            for (int i = 0; i < atts.size(); ++i) {
                AttributeDescriptor att = (AttributeDescriptor)atts.get(i);
                if (!this.defaultGeometry.equals(att.getName().getLocalPart())) continue;
                if (!(att.getType() instanceof GeometryType)) {
                    this.attributeBuilder.init(att);
                    GeometryType type = this.attributeBuilder.buildGeometryType();
                    att = this.attributeBuilder.buildDescriptor(att.getName(), (AttributeType)type);
                    atts.set(i, att);
                }
                defaultGeometry = att;
                break;
            }
            if (defaultGeometry == null) {
                String msg = "'" + this.defaultGeometry + " specified as default" + " but could find no such attribute.";
                throw new IllegalArgumentException(msg);
            }
        }
        if (defaultGeometry == null) {
            for (AttributeDescriptor att : this.attributes()) {
                if (!(att.getType() instanceof GeometryType)) continue;
                defaultGeometry = att;
                break;
            }
        }
        if ((crs = this.crs) == null && defaultGeometry != null) {
            crs = ((GeometryType)defaultGeometry.getType()).getCRS();
        }
        SimpleFeatureType built = this.factory.createSimpleFeatureType(this.name(), this.attributes(), defaultGeometry, crs, this.isAbstract, this.restrictions(), this.superType, this.description);
        this.init();
        return built;
    }

    protected boolean isGeometry(Class binding) {
        return false;
    }

    protected Set newSet() {
        return new HashSet();
    }

    protected List newList() {
        return new ArrayList();
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected List newList(List origional) {
        if (origional == null) {
            return this.newList();
        }
        if (origional == Collections.EMPTY_LIST) {
            return this.newList();
        }
        try {
            return (List)origional.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return this.newList();
        }
        catch (IllegalAccessException e) {
            return this.newList();
        }
    }

    protected Name name() {
        if (this.local == null) {
            return null;
        }
        return new TypeName(this.uri, this.local);
    }

    protected List attributes() {
        if (this.attributes == null) {
            this.attributes = this.newList();
        }
        return this.attributes;
    }

    protected Set restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.newSet();
        }
        return this.restrictions;
    }

    protected Map bindings() {
        if (this.bindings == null) {
            this.bindings = this.newMap();
        }
        return this.bindings;
    }
}

