/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.FilteredIterator;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public class SubFeatureCollection
extends BaseFeatureCollection
implements FeatureCollection {
    protected Filter filter;
    protected FeatureCollection collection;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected AbstractResourceCollection rc;

    public SubFeatureCollection(FeatureCollection collection) {
        this(collection, null);
    }

    public SubFeatureCollection(FeatureCollection collection, Filter subfilter) {
        super(null, collection.getFeatureCollectionType());
        if (subfilter != null && subfilter.equals(Filter.EXCLUDE)) {
            throw new IllegalArgumentException("A subcollection with Filter.EXCLUDE is a null operation");
        }
        if (subfilter != null && subfilter.equals(Filter.INCLUDE)) {
            throw new IllegalArgumentException("A subcollection with Filter.INCLUDE should be a FeatureCollectionEmpty");
        }
        if (subfilter != null && collection instanceof SubFeatureCollection) {
            SubFeatureCollection filtered = (SubFeatureCollection)collection;
            this.collection = filtered.collection;
            this.filter = this.ff.and(filtered.filter(), subfilter);
        } else {
            this.collection = collection;
            this.filter = subfilter;
        }
        this.rc = this.createResourceCollection();
    }

    AbstractResourceCollection createResourceCollection() {
        return new AbstractResourceCollection(){

            public Iterator openIterator() {
                return new FilteredIterator(SubFeatureCollection.this.collection, SubFeatureCollection.this.filter());
            }

            public void closeIterator(Iterator iterator) {
                if (iterator == null) {
                    return;
                }
                if (iterator instanceof FilteredIterator) {
                    FilteredIterator filtered = (FilteredIterator)iterator;
                    filtered.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int size() {
                int count = 0;
                Iterator i = null;
                try {
                    i = this.iterator();
                    while (i.hasNext()) {
                        i.next();
                        ++count;
                    }
                }
                finally {
                    this.close(i);
                }
                return count;
            }
        };
    }

    protected Filter filter() {
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
        return this.filter;
    }

    protected Filter createFilter() {
        return Filter.INCLUDE;
    }

    public FeatureIterator features() {
        return new DelegateFeatureIterator(this, this.iterator());
    }

    public void close(FeatureIterator close) {
        if (close != null) {
            close.close();
        }
    }

    public FeatureCollection subCollection(Filter filter) {
        if (filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureCollection(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Iterator iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            this.close(iterator);
        }
    }

    public FeatureType getSchema() {
        return this.collection.getSchema();
    }

    public final void accepts(org.geotools.feature.visitor.FeatureVisitor visitor, org.geotools.util.ProgressListener progress) throws IOException {
        this.accepts((FeatureVisitor)visitor, (ProgressListener)progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        Iterator iterator = null;
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit((org.opengis.feature.Feature)feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureReader reader() throws IOException {
        return new DelegateFeatureReader(this.getSchema(), this.features());
    }

    public int getCount() throws IOException {
        return this.size();
    }

    public FeatureCollection collection() throws IOException {
        return this;
    }

    public FeatureCollection sort(SortBy order) {
        return null;
    }

    public void purge() {
        this.collection.purge();
    }

    public void close(Iterator close) {
        this.rc.close(close);
    }

    public Iterator iterator() {
        return this.rc.iterator();
    }

    public boolean add(Object o) {
        return this.rc.add(o);
    }

    public boolean addAll(Collection c) {
        return this.rc.addAll(c);
    }

    public void clear() {
        this.rc.clear();
    }

    public boolean contains(Object o) {
        return this.rc.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.rc.containsAll(c);
    }

    public boolean remove(Object o) {
        return this.rc.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.rc.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.rc.retainAll(c);
    }

    public int size() {
        return this.rc.size();
    }

    public Object[] toArray() {
        return this.rc.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.rc.toArray(a);
    }
}

