/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsNull;

public class Schema {
    private static Schema DEFAULT = new Schema();
    private FilterFactory ff;

    public Schema() {
        this((Hints)null);
    }

    public Schema(Hints hints) {
        this(CommonFactoryFinder.getFilterFactory(hints));
    }

    public Schema(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public int getAttributeCount(FeatureType featureType) {
        return this.getNames(featureType).size();
    }

    public List getNames(FeatureType featureType) {
        return this.getNames(featureType, new ArrayList());
    }

    public List getNames(FeatureType featureType, List names) {
        AttributeType[] attributes;
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return names;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            for (FeatureType superType : ancestors) {
                this.getNames(superType, names);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            for (AttributeType type : attributes) {
                String name = type.getLocalName();
                if (names.contains(name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public List getAttributes(FeatureType featureType) {
        return this.getAttributes(featureType, new ArrayList());
    }

    public List getAttributes(FeatureType featureType, List list) {
        AttributeType[] attributes;
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return list;
        }
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            int length = ancestors.length;
            for (int i = 0; i < length; ++i) {
                this.getAttributes(ancestors[i], list);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            for (AttributeType type : attributes) {
                String name = type.getLocalName();
                int index = this.getIndexOf(list, name);
                if (index != -1) {
                    AttributeType origional = (AttributeType)list.get(index);
                    list.remove(index);
                    list.add(index, this.override(origional, type));
                    continue;
                }
                list.add(type);
            }
        }
        return list;
    }

    public Filter getRestrictions(FeatureType featureType, String name) {
        if (featureType == null || featureType.getAttributeTypes() == null) {
            return Filter.EXCLUDE;
        }
        return this.restriction(featureType, name, (Filter)Filter.INCLUDE);
    }

    public int getIndexOf(FeatureType type, String name) {
        List names = this.getNames(type);
        return names.indexOf(name);
    }

    public AttributeType getAttribute(FeatureType type, int index) {
        String name = (String)this.getNames(type).get(index);
        return this.getXPath(type, name);
    }

    public AttributeType getAttribute(FeatureType type, String name) {
        List list = this.getAttributes(type);
        int index = this.getIndexOf(list, name);
        if (index == -1) {
            return null;
        }
        return (AttributeType)list.get(index);
    }

    public AttributeType getXPath(FeatureType type, String xpath) {
        return this.getAttribute(type, xpath);
    }

    private int getIndexOf(List attributes, String name) {
        int index = 0;
        for (AttributeType type : attributes) {
            if (name.equals(type.getLocalName())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private AttributeType override(AttributeType type, AttributeType override) {
        String name;
        int min;
        int max = override.getMaxOccurs();
        if (max < 0) {
            max = type.getMinOccurs();
        }
        if ((min = override.getMinOccurs()) < 0) {
            min = type.getMinOccurs();
        }
        if ((name = override.getLocalName()) == null) {
            name = type.getLocalName();
        }
        Filter restriction = this.override(type.getRestriction(), override.getRestriction());
        Class javaType = override.getBinding();
        if (javaType == null) {
            javaType = type.getBinding();
        }
        boolean isNilable = override.isNillable();
        Object defaultValue = override.createDefaultValue();
        if (defaultValue == null) {
            defaultValue = type.createDefaultValue();
        }
        return AttributeTypeFactory.newAttributeType(name, javaType, isNilable, restriction, defaultValue, null);
    }

    private Filter restriction(FeatureType featureType, String name, Filter filter) {
        AttributeType[] attributes;
        FeatureType[] ancestors = featureType.getAncestors();
        if (ancestors != null && ancestors.length != 0) {
            for (FeatureType superType : ancestors) {
                filter = this.restriction(superType, name, filter);
            }
        }
        if ((attributes = featureType.getAttributeTypes()) != null && attributes.length != 0) {
            for (AttributeType type : attributes) {
                if (!name.equals(type.getLocalName())) continue;
                filter = this.override(filter, type.getRestriction());
            }
        }
        return filter;
    }

    private Filter override(Filter filter, Filter override) {
        if (this.isNOP(override)) {
            return filter;
        }
        if (this.isNOP(filter)) {
            return override;
        }
        return this.ff.and(filter, override);
    }

    private boolean isNOP(Filter filter) {
        return filter == null || filter instanceof PropertyIsNull || filter == Filter.INCLUDE;
    }

    public static int attributeCount(FeatureType featureType) {
        return DEFAULT.getAttributeCount(featureType);
    }

    public static AttributeType attribute(FeatureType type, int index) {
        return DEFAULT.getAttribute(type, index);
    }

    public static AttributeType attribute(FeatureType type, String name) {
        return DEFAULT.getAttribute(type, name);
    }

    public static List attributes(FeatureType featureType) {
        return DEFAULT.getAttributes(featureType);
    }

    public static List attributes(FeatureType featureType, List list) {
        return DEFAULT.getAttributes(featureType, list);
    }

    public static int find(FeatureType type, String name) {
        return DEFAULT.getIndexOf(type, name);
    }

    public static List names(FeatureType featureType) {
        return DEFAULT.getNames(featureType);
    }

    public static List names(FeatureType featureType, List names) {
        return DEFAULT.getNames(featureType, names);
    }

    public static Filter restriction(FeatureType featureType, String name) {
        return DEFAULT.getRestrictions(featureType, name);
    }

    public static AttributeType xpath(FeatureType type, String xpath) {
        return DEFAULT.getAttribute(type, xpath);
    }
}

