/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.List;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.type.Types;
import org.geotools.resources.Utilities;
import org.geotools.util.Converters;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

public class AttributeImpl
implements Attribute {
    protected Object content;
    protected AttributeDescriptor DESCRIPTOR;
    protected final AttributeType TYPE;
    protected final String ID;

    public AttributeImpl(Object content, AttributeDescriptor descriptor, String id) {
        this(content == null && !descriptor.isNillable() ? descriptor.getDefaultValue() : content, descriptor.getType(), id);
        this.DESCRIPTOR = descriptor;
    }

    public AttributeImpl(Object content, AttributeType type, String id) {
        this.TYPE = type;
        this.ID = id;
        this.setValue(content);
    }

    public String getID() {
        return this.ID;
    }

    public Object getValue() {
        return this.content;
    }

    public AttributeDescriptor getDescriptor() {
        return this.DESCRIPTOR;
    }

    public PropertyDescriptor descriptor() {
        return this.getDescriptor();
    }

    public AttributeType getType() {
        return this.TYPE;
    }

    public Name name() {
        return this.DESCRIPTOR != null ? this.DESCRIPTOR.getName() : null;
    }

    public boolean nillable() {
        if (this.getDescriptor() != null) {
            return this.getDescriptor().isNillable();
        }
        return true;
    }

    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        newValue = this.parse(newValue);
        try {
            Types.validate(this.getType(), this, newValue);
        }
        catch (IllegalAttributeException e) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e);
        }
        this.content = newValue;
    }

    public int hashCode() {
        return 37 * (this.DESCRIPTOR == null ? 0 : this.DESCRIPTOR.hashCode()) + 37 * (this.TYPE == null ? 0 : this.TYPE.hashCode()) + 37 * (this.ID == null ? 0 : this.ID.hashCode()) + 37 * (this.content == null ? 0 : this.content.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof AttributeImpl)) {
            return false;
        }
        AttributeImpl att = (AttributeImpl)other;
        if (!Utilities.equals((Object)this.DESCRIPTOR, (Object)att.DESCRIPTOR)) {
            return false;
        }
        if (!Utilities.equals((Object)this.TYPE, (Object)att.TYPE)) {
            return false;
        }
        if (!Utilities.equals((Object)this.ID, (Object)att.ID)) {
            return false;
        }
        return Utilities.equals((Object)this.content, (Object)att.content);
    }

    public Object operation(Name arg0, List arg1) {
        throw new UnsupportedOperationException("operation not supported yet");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Attribute[");
        sb.append(this.DESCRIPTOR == null ? "" : this.DESCRIPTOR.getName().getLocalPart());
        sb.append(":");
        sb.append(this.TYPE.getName().getLocalPart());
        sb.append(":@");
        sb.append(this.ID == null ? "" : this.ID);
        sb.append(":");
        sb.append(this.content);
        sb.append("]");
        return this.content == null ? "" : this.content.toString();
    }

    protected Object parse(Object value) throws IllegalArgumentException {
        Object converted;
        Class target;
        if (value != null && !(target = this.getType().getBinding()).isAssignableFrom(value.getClass()) && (converted = Converters.convert(value, target)) != null) {
            value = converted;
        }
        return value;
    }
}

