/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.view;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultView
implements FeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.view");
    protected FeatureSource source;
    private FeatureType schema;
    private Query constraintQuery;

    public DefaultView(FeatureSource source, Query query) throws SchemaException {
        this.source = source;
        this.constraintQuery = query;
        FeatureType origionalType = source.getSchema();
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        this.schema = DataUtilities.createSubType(origionalType, query.getPropertyNames(), cs, query.getTypeName(), null);
    }

    public static FeatureSource create(FeatureSource source, Query query) throws SchemaException {
        if (source instanceof FeatureLocking || source instanceof FeatureStore) {
            // empty if block
        }
        return new DefaultView(source, query);
    }

    protected DefaultQuery makeDefinitionQuery(Query query) throws IOException {
        if (query == Query.ALL || query.equals(Query.ALL)) {
            return new DefaultQuery(this.constraintQuery);
        }
        try {
            URI namespace;
            String[] propNames = this.extractAllowedAttributes(query);
            String typeName = query.getTypeName();
            if (typeName == null) {
                typeName = this.constraintQuery.getTypeName();
            }
            if ((namespace = query.getNamespace()) == null || namespace == Query.NO_NAMESPACE) {
                namespace = this.constraintQuery.getNamespace();
            }
            Filter filter = this.makeDefinitionFilter(query.getFilter());
            int maxFeatures = Math.min(query.getMaxFeatures(), this.constraintQuery.getMaxFeatures());
            String handle = query.getHandle();
            if (handle == null) {
                handle = this.constraintQuery.getHandle();
            } else if (this.constraintQuery.getHandle() != null) {
                handle = handle + "(" + this.constraintQuery.getHandle() + ")";
            }
            DefaultQuery defaultQuery = new DefaultQuery(typeName, namespace, filter, maxFeatures, propNames, handle);
            defaultQuery.setSortBy(query.getSortBy());
            return defaultQuery;
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] extractAllowedAttributes(Query query) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            propNames = new String[this.schema.getAttributeCount()];
            for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
                propNames[i] = this.schema.getAttributeType(i).getLocalName();
            }
        } else {
            String[] queriedAtts = query.getPropertyNames();
            int queriedAttCount = queriedAtts.length;
            LinkedList<String> allowedAtts = new LinkedList<String>();
            for (int i = 0; i < queriedAttCount; ++i) {
                if (this.schema.getAttributeType(queriedAtts[i]) != null) {
                    allowedAtts.add(queriedAtts[i]);
                    continue;
                }
                LOGGER.info("queried a not allowed property: " + queriedAtts[i] + ". Ommitting it from query");
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        Filter constraintFilter = this.constraintQuery.getFilter();
        try {
            if (constraintFilter != Filter.INCLUDE) {
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                newFilter = ff.and(constraintFilter, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the constraint filter", (Throwable)ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public FeatureCollection getFeatures(Query query) throws IOException {
        FeatureCollection results;
        block12: {
            DefaultQuery mergedQuery = this.makeDefinitionQuery(query);
            results = this.source.getFeatures((Query)mergedQuery);
            CoordinateReferenceSystem cCs = this.constraintQuery.getCoordinateSystem();
            CoordinateReferenceSystem cCsr = this.constraintQuery.getCoordinateSystemReproject();
            CoordinateReferenceSystem qCs = query.getCoordinateSystem();
            CoordinateReferenceSystem qCsr = query.getCoordinateSystemReproject();
            try {
                CoordinateReferenceSystem reprojectCS;
                if (qCsr != null && cCsr != null) {
                    if (cCs != null) {
                        results = new ForceCoordinateSystemFeatureResults(results, cCs);
                    }
                    results = new ReprojectFeatureResults(results, cCsr);
                    if (qCs != null) {
                        results = new ForceCoordinateSystemFeatureResults(results, qCs);
                    }
                    results = new ReprojectFeatureResults(results, qCsr);
                    break block12;
                }
                if (qCs != null && cCsr != null) {
                    try {
                        if (cCs != null) {
                            results = new ForceCoordinateSystemFeatureResults(results, cCs);
                        }
                        results = new ReprojectFeatureResults(this.source.getFeatures((Query)mergedQuery), cCsr);
                        results = new ForceCoordinateSystemFeatureResults(results, qCs);
                        break block12;
                    }
                    catch (SchemaException e) {
                        throw new DataSourceException("This should not happen", (Throwable)e);
                    }
                }
                CoordinateReferenceSystem forcedCS = qCs != null ? qCs : cCs;
                CoordinateReferenceSystem coordinateReferenceSystem = reprojectCS = qCsr != null ? qCsr : cCsr;
                if (forcedCS != null) {
                    results = new ForceCoordinateSystemFeatureResults(results, forcedCS);
                }
                if (reprojectCS != null) {
                    results = new ReprojectFeatureResults(results, reprojectCS);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataSourceException("A problem occurred while handling forced coordinate systems and reprojection", (Throwable)e);
            }
        }
        return results;
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.schema.getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public Envelope getBounds() throws IOException {
        if (this.constraintQuery.getCoordinateSystemReproject() == null) {
            if (this.constraintQuery.getFilter() == null || this.constraintQuery.getFilter() == Filter.INCLUDE || Filter.INCLUDE.equals((Object)this.constraintQuery.getFilter())) {
                return this.source.getBounds();
            }
            return this.source.getBounds(this.constraintQuery);
        }
        return this.getFeatures().getBounds();
    }

    public Envelope getBounds(Query query) throws IOException {
        if (this.constraintQuery.getCoordinateSystemReproject() == null) {
            try {
                query = this.makeDefinitionQuery(query);
            }
            catch (IOException ex) {
                return null;
            }
            return this.source.getBounds(query);
        }
        return this.getFeatures(query).getBounds();
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Set getSupportedHints() {
        return this.source.getSupportedHints();
    }
}

