/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureIterator;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.collection.AbstractResourceCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureResults
extends AbstractFeatureCollection {
    FeatureCollection results;
    MathTransform transform;

    public ReprojectFeatureResults(FeatureCollection results, CoordinateReferenceSystem destinationCS) throws IOException, SchemaException, TransformException, OperationNotFoundException, NoSuchElementException, FactoryException {
        super(ReprojectFeatureResults.forceType(ReprojectFeatureResults.origionalType(results), destinationCS));
        this.results = ReprojectFeatureResults.origionalCollection(results);
        CoordinateReferenceSystem originalCs = results.getSchema().getPrimaryGeometry().getCoordinateSystem();
        this.transform = CRS.findMathTransform((CoordinateReferenceSystem)originalCs, (CoordinateReferenceSystem)destinationCS, (boolean)true);
        this.setResourceCollection(this.createResourceCollection());
    }

    private AbstractResourceCollection createResourceCollection() {
        return new AbstractResourceCollection(){

            public Iterator openIterator() {
                return new ReprojectFeatureIterator(ReprojectFeatureResults.this.results.features(), ReprojectFeatureResults.this.getSchema(), ReprojectFeatureResults.this.transform);
            }

            public void closeIterator(Iterator close) {
                if (close == null) {
                    return;
                }
                if (close instanceof ReprojectFeatureIterator) {
                    ReprojectFeatureIterator iterator = (ReprojectFeatureIterator)close;
                    iterator.close();
                }
            }

            public int size() {
                return ReprojectFeatureResults.this.results.size();
            }
        };
    }

    private static FeatureCollection origionalCollection(FeatureCollection results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results;
    }

    private static FeatureType origionalType(FeatureCollection results) {
        if (results instanceof ReprojectFeatureResults) {
            results = ((ReprojectFeatureResults)results).getOrigin();
        }
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            results = ((ForceCoordinateSystemFeatureResults)results).getOrigin();
        }
        return results.getSchema();
    }

    private static FeatureType forceType(FeatureType startingType, CoordinateReferenceSystem forcedCS) throws SchemaException {
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = startingType.getPrimaryGeometry().getCoordinateSystem();
        if (forcedCS.equals(originalCs)) {
            return startingType;
        }
        return FeatureTypes.transform(startingType, forcedCS);
    }

    public ReferencedEnvelope getBounds() {
        FeatureIterator r = this.features();
        try {
            Envelope newBBox = new Envelope();
            while (r.hasNext()) {
                Feature feature = r.next();
                Envelope internal = feature.getPrimaryGeometry().getEnvelopeInternal();
                newBBox.expandToInclude(internal);
            }
            ReferencedEnvelope referencedEnvelope = ReferencedEnvelope.reference((Envelope)newBBox);
            return referencedEnvelope;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
        }
        finally {
            r.close();
        }
    }

    public FeatureCollection getOrigin() {
        return this.results;
    }
}

