/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.defaults;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFactory;
import org.geotools.catalog.ServiceFinder;
import org.geotools.factory.FactoryRegistry;

public class DefaultServiceFinder
implements ServiceFinder {
    private Catalog catalog;

    public DefaultServiceFinder(Catalog catalog) {
        this.catalog = catalog;
    }

    public List aquire(URI id, Map params) {
        ArrayList<Service> services = new ArrayList<Service>();
        List extensions = this.getServiceFactories();
        for (ServiceFactory se : extensions) {
            try {
                Service service = se.createService(this.catalog, id, params);
                if (service == null) continue;
                services.add(service);
            }
            catch (Throwable t) {}
        }
        return services;
    }

    public List aquire(Map params) {
        return this.aquire(null, params);
    }

    public List aquire(URI target) {
        LinkedList<Map> maps = new LinkedList<Map>();
        List extensions = this.getServiceFactories();
        for (ServiceFactory se : extensions) {
            try {
                Map m;
                if (!se.canProcess(target) || (m = se.createParams(target)) == null) continue;
                maps.add(m);
            }
            catch (Throwable t) {}
        }
        LinkedList services = new LinkedList();
        Iterator i = maps.iterator();
        while (i.hasNext()) {
            List o = this.aquire(target, (Map)i.next());
            if (o == null || o.isEmpty()) continue;
            services.addAll(o);
        }
        return services;
    }

    public List getServiceFactories() {
        Iterator f = FactoryRegistry.lookupProviders(ServiceFactory.class);
        ArrayList factories = new ArrayList();
        while (f.hasNext()) {
            factories.add(f.next());
        }
        return factories;
    }
}

