/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.resources.JDBC;
import org.geotools.resources.i18n.Errors;

public class SimpleDataSource
implements DataSource {
    protected final Properties properties;

    public SimpleDataSource(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    public SimpleDataSource(File file) throws IOException {
        this.properties = new Properties();
        FileInputStream in = new FileInputStream(file);
        this.properties.load(in);
        ((InputStream)in).close();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public int getPriority() {
        return 50;
    }

    private String getURL() {
        LogRecord log = JDBC.loadDriver(this.properties.getProperty("driver", "sun.jdbc.odbc.JdbcOdbcDriver"));
        if (log != null) {
            log.setSourceClassName(SimpleDataSource.class.getName());
            log.setSourceMethodName("getConnection");
            ReferencingFactory.LOGGER.log(log);
        }
        return this.properties.getProperty("url", "jdbc:odbc:EPSG");
    }

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.getURL(), this.properties);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return DriverManager.getConnection(this.getURL(), username, password);
    }

    public AbstractAuthorityFactory createFactory(Hints hints) throws SQLException {
        AbstractAuthorityFactory factory;
        Connection connection = this.getConnection();
        String classname = this.properties.getProperty("factory");
        if (classname == null) {
            classname = "org.geotools.referencing.factory.epsg.DirectEpsgFactory";
            String driver = this.properties.getProperty("driver");
            if (driver != null) {
                if (driver.indexOf(".postgresql.") >= 0 || driver.indexOf(".mysql.") >= 0) {
                    classname = "org.geotools.referencing.factory.epsg.AnsiDialectEpsgFactory";
                } else if (driver.startsWith("oracle.")) {
                    classname = "org.geotools.referencing.factory.epsg.OracleDialectEpsgFactory";
                } else if (driver.indexOf(".hsqldb.") >= 0) {
                    classname = "org.geotools.referencing.factory.epsg.FactoryUsingHSQL";
                }
            }
        }
        try {
            Class<?> classe = Class.forName(classname);
            Constructor<?> c = classe.getConstructor(Hints.class, Connection.class);
            factory = (AbstractAuthorityFactory)c.newInstance(hints, connection);
        }
        catch (Exception exception) {
            SQLException e = new SQLException(Errors.format(154, this.getURL()));
            e.initCause(exception);
            throw e;
        }
        String schema = this.properties.getProperty("schema");
        if (schema != null && factory instanceof FactoryUsingAnsiSQL) {
            ((FactoryUsingAnsiSQL)factory).setSchema(schema);
        }
        return factory;
    }

    public Object unwrap(Class type) throws SQLException {
        throw new SQLException();
    }

    public boolean isWrapperFor(Class type) throws SQLException {
        return false;
    }
}

