/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import java.util.logging.Level;
import javax.units.Unit;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AbstractCachedAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryProxy;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorityMediator
extends AbstractAuthorityFactory
implements AuthorityFactory,
CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory,
BufferedFactory {
    static final int PRIORITY = 90;
    ObjectCache cache;
    ObjectCache findCache;
    private ObjectPool workers;
    GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
    protected final ReferencingFactoryContainer factories;

    protected AbstractAuthorityMediator() {
        this(90);
    }

    protected AbstractAuthorityMediator(Hints hints) {
        this(90, hints);
    }

    protected AbstractAuthorityMediator(int priority) {
        this(priority, ObjectCaches.create("weak", 50), ReferencingFactoryContainer.instance(null));
    }

    protected AbstractAuthorityMediator(int priority, Hints hints) {
        this(priority, ObjectCaches.create(hints), ReferencingFactoryContainer.instance(hints));
        this.poolConfig.minIdle = Hints.AUTHORITY_MIN_IDLE.toValue(hints);
        this.poolConfig.maxIdle = Hints.AUTHORITY_MAX_IDLE.toValue(hints);
        this.poolConfig.maxActive = Hints.AUTHORITY_MAX_ACTIVE.toValue(hints);
        this.poolConfig.minEvictableIdleTimeMillis = Hints.AUTHORITY_MIN_EVICT_IDLETIME.toValue(hints);
        this.poolConfig.softMinEvictableIdleTimeMillis = Hints.AUTHORITY_SOFTMIN_EVICT_IDLETIME.toValue(hints);
        this.poolConfig.timeBetweenEvictionRunsMillis = Hints.AUTHORITY_TIME_BETWEEN_EVICTION_RUNS.toValue(hints);
        this.poolConfig.maxWait = -1L;
        this.poolConfig.whenExhaustedAction = 1;
    }

    protected AbstractAuthorityMediator(int priority, ObjectCache cache, ReferencingFactoryContainer container) {
        super(priority);
        this.factories = container;
        this.cache = cache;
        this.findCache = ObjectCaches.chain(ObjectCaches.create("weak", 0), cache);
    }

    protected void completeHints() {
        this.hints.put(Hints.DATUM_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.CS_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.CRS_AUTHORITY_FACTORY, this);
        this.hints.put(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this);
    }

    public boolean isConnected() {
        return this.workers.getNumActive() + this.workers.getNumIdle() > 0;
    }

    ObjectPool getPool() {
        if (this.workers == null) {
            AuthorityPoolableObjectFactory objectFactory = new AuthorityPoolableObjectFactory();
            GenericObjectPoolFactory poolFactory = new GenericObjectPoolFactory((PoolableObjectFactory)objectFactory, this.poolConfig);
            this.setPool(poolFactory.createPool());
        }
        return this.workers;
    }

    void setPool(ObjectPool pool) {
        this.workers = pool;
    }

    protected String toKey(String code) {
        return ObjectCaches.toKey(this.getAuthority(), code);
    }

    @Override
    protected String trimAuthority(String code) {
        return this.toKey(code);
    }

    @Override
    public abstract Citation getAuthority();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAuthorityCodes(Class type) throws FactoryException {
        Set codes;
        block14: {
            codes = (Set)this.cache.get(type);
            if (codes == null) {
                try {
                    this.cache.writeLock(type);
                    codes = (Set)this.cache.peek(type);
                    if (codes != null) break block14;
                    AbstractCachedAuthorityFactory worker = null;
                    try {
                        worker = (AbstractCachedAuthorityFactory)this.getPool().borrowObject();
                        codes = worker.getAuthorityCodes(type);
                        this.cache.put(type, codes);
                    }
                    catch (FactoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FactoryException(e);
                    }
                    finally {
                        try {
                            this.getPool().returnObject((Object)worker);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
                        }
                    }
                }
                finally {
                    this.cache.writeUnLock(type);
                }
            }
        }
        return codes;
    }

    public abstract InternationalString getDescriptionText(String var1) throws FactoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        IdentifiedObject obj;
        block14: {
            String key = this.toKey(code);
            obj = (IdentifiedObject)this.cache.get(key);
            if (obj == null) {
                try {
                    this.cache.writeLock(key);
                    obj = (IdentifiedObject)this.cache.peek(key);
                    if (obj != null) break block14;
                    AbstractCachedAuthorityFactory worker = null;
                    try {
                        worker = (AbstractCachedAuthorityFactory)this.getPool().borrowObject();
                        obj = worker.createDerivedCRS(code);
                        this.cache.put(key, obj);
                    }
                    catch (FactoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FactoryException(e);
                    }
                    finally {
                        try {
                            this.getPool().returnObject((Object)worker);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
                        }
                    }
                }
                finally {
                    this.cache.writeUnLock(key);
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        CompoundCRS crs;
        block14: {
            String key = this.toKey(code);
            crs = (CompoundCRS)this.cache.get(key);
            if (crs == null) {
                try {
                    this.cache.writeLock(key);
                    crs = (CompoundCRS)this.cache.peek(key);
                    if (crs != null) break block14;
                    AbstractCachedAuthorityFactory worker = null;
                    try {
                        worker = (AbstractCachedAuthorityFactory)this.getPool().borrowObject();
                        crs = worker.createCompoundCRS(code);
                        this.cache.put(key, crs);
                    }
                    catch (FactoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FactoryException(e);
                    }
                    finally {
                        try {
                            this.getPool().returnObject((Object)worker);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
                        }
                    }
                }
                finally {
                    this.cache.writeUnLock(key);
                }
            }
        }
        return crs;
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CoordinateReferenceSystem)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCoordinateReferenceSystem(key);
            }
        });
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (DerivedCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createEngineeringCRS(key);
            }
        });
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (GeocentricCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createGeocentricCRS(key);
            }
        });
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (GeographicCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createGeographicCRS(key);
            }
        });
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (ImageCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createImageCRS(key);
            }
        });
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (ProjectedCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createProjectedCRS(key);
            }
        });
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (TemporalCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createTemporalCRS(key);
            }
        });
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (VerticalCRS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createVerticalCRS(key);
            }
        });
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CartesianCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCartesianCS(key);
            }
        });
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CoordinateSystem)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCoordinateSystem(key);
            }
        });
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CoordinateSystemAxis)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCoordinateSystemAxis(key);
            }
        });
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CylindricalCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCylindricalCS(key);
            }
        });
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (EllipsoidalCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createEllipsoidalCS(key);
            }
        });
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (PolarCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createPolarCS(key);
            }
        });
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (SphericalCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createSphericalCS(key);
            }
        });
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (TimeCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createTimeCS(key);
            }
        });
    }

    @Override
    public Unit createUnit(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (Unit)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createUnit(key);
            }
        });
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (VerticalCS)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createVerticalCS(key);
            }
        });
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (Datum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createDatum(key);
            }
        });
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (Ellipsoid)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createEllipsoid(key);
            }
        });
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (EngineeringDatum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createEngineeringDatum(key);
            }
        });
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (GeodeticDatum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createGeodeticDatum(key);
            }
        });
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (ImageDatum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createImageDatum(key);
            }
        });
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (PrimeMeridian)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createPrimeMeridian(key);
            }
        });
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (TemporalDatum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createTemporalDatum(key);
            }
        });
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (VerticalDatum)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createVerticalDatum(key);
            }
        });
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        final String key = this.toKey(code);
        return (CoordinateOperation)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createCoordinateOperation(key);
            }
        });
    }

    @Override
    public synchronized Set createFromCoordinateReferenceSystemCodes(final String sourceCode, final String targetCode) throws FactoryException {
        Object key = ObjectCaches.toKey(this.getAuthority(), sourceCode, targetCode);
        return (Set)this.createWith(key, new WorkerSafeRunnable(){

            public Object run(AbstractCachedAuthorityFactory worker) throws FactoryException {
                return worker.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T createWith(Object key, WorkerSafeRunnable runner) throws FactoryException {
        Object value;
        block14: {
            value = this.cache.get(key);
            if (value == null) {
                try {
                    this.cache.writeLock(key);
                    value = this.cache.peek(key);
                    if (value != null) break block14;
                    AbstractCachedAuthorityFactory worker = null;
                    try {
                        worker = (AbstractCachedAuthorityFactory)this.getPool().borrowObject();
                        value = runner.run(worker);
                    }
                    catch (FactoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new FactoryException(e);
                    }
                    finally {
                        try {
                            this.getPool().returnObject((Object)worker);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
                        }
                    }
                    this.cache.put(key, value);
                }
                finally {
                    this.cache.writeUnLock(key);
                }
            }
        }
        return (T)value;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractCachedAuthorityFactory worker = null;
        try {
            worker = (AbstractCachedAuthorityFactory)this.getPool().borrowObject();
            String string = worker.getBackingStoreDescription();
            return string;
        }
        catch (FactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FactoryException(e);
        }
        finally {
            try {
                this.getPool().returnObject((Object)worker);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
            }
        }
    }

    @Override
    public void dispose() throws FactoryException {
        if (this.workers != null) {
            try {
                this.workers.clear();
            }
            catch (FactoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FactoryException(e);
            }
            this.workers = null;
        }
    }

    protected abstract void activateWorker(AbstractCachedAuthorityFactory var1) throws Exception;

    protected abstract void destroyWorker(AbstractCachedAuthorityFactory var1) throws Exception;

    protected abstract AbstractCachedAuthorityFactory makeWorker() throws Exception;

    protected abstract void passivateWorker(AbstractCachedAuthorityFactory var1) throws Exception;

    protected abstract boolean validateWorker(AbstractCachedAuthorityFactory var1);

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new LazyCachedFinder(type);
    }

    private final class LazyCachedFinder
    extends IdentifiedObjectFinder {
        private Class type;

        LazyCachedFinder(Class type) {
            super(AbstractAuthorityMediator.this, type);
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = (IdentifiedObject)AbstractAuthorityMediator.this.findCache.get(object);
            if (candidate != null) {
                return candidate;
            }
            try {
                IdentifiedObject found;
                AbstractAuthorityMediator.this.findCache.writeLock(object);
                AbstractCachedAuthorityFactory worker = null;
                try {
                    worker = (AbstractCachedAuthorityFactory)AbstractAuthorityMediator.this.getPool().borrowObject();
                    worker.cache = ObjectCaches.chain(ObjectCaches.create("weak", 3000), AbstractAuthorityMediator.this.cache);
                    worker.findCache = AbstractAuthorityMediator.this.findCache;
                    this.setProxy(AuthorityFactoryProxy.getInstance(worker, this.type));
                    found = super.find(object);
                }
                catch (Exception e) {
                    throw new FactoryException(e);
                }
                finally {
                    this.setProxy(null);
                    worker.cache = AbstractAuthorityMediator.this.cache;
                    worker.findCache = AbstractAuthorityMediator.this.findCache;
                    try {
                        AbstractAuthorityMediator.this.getPool().returnObject((Object)worker);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Unable to return worker " + e, e);
                    }
                }
                if (found == null) {
                    IdentifiedObject identifiedObject = null;
                    return identifiedObject;
                }
                candidate = (IdentifiedObject)AbstractAuthorityMediator.this.findCache.peek(object);
                if (candidate == null) {
                    AbstractAuthorityMediator.this.findCache.put(object, found);
                    IdentifiedObject identifiedObject = found;
                    return identifiedObject;
                }
                IdentifiedObject identifiedObject = candidate;
                return identifiedObject;
            }
            finally {
                AbstractAuthorityMediator.this.findCache.writeUnLock(object);
            }
        }

        protected Citation getAuthority() {
            return AbstractAuthorityMediator.this.getAuthority();
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = (IdentifiedObject)AbstractAuthorityMediator.this.findCache.get(object);
            if (candidate != null) {
                return this.getIdentifier(candidate);
            }
            return super.findIdentifier(object);
        }
    }

    private class AuthorityPoolableObjectFactory
    implements PoolableObjectFactory {
        AuthorityPoolableObjectFactory() {
        }

        public void activateObject(Object obj) throws Exception {
            AbstractCachedAuthorityFactory worker = (AbstractCachedAuthorityFactory)obj;
            worker.cache = AbstractAuthorityMediator.this.cache;
            AbstractAuthorityMediator.this.activateWorker(worker);
        }

        public void destroyObject(Object obj) throws Exception {
            AbstractAuthorityMediator.this.destroyWorker((AbstractCachedAuthorityFactory)obj);
        }

        public Object makeObject() throws Exception {
            AbstractCachedAuthorityFactory worker = AbstractAuthorityMediator.this.makeWorker();
            return worker;
        }

        public void passivateObject(Object obj) throws Exception {
            AbstractAuthorityMediator.this.passivateWorker((AbstractCachedAuthorityFactory)obj);
        }

        public boolean validateObject(Object obj) {
            return AbstractAuthorityMediator.this.validateWorker((AbstractCachedAuthorityFactory)obj);
        }
    }

    protected abstract class WorkerSafeRunnable {
        protected WorkerSafeRunnable() {
        }

        public abstract Object run(AbstractCachedAuthorityFactory var1) throws FactoryException;
    }
}

