/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Map;
import javax.units.Unit;
import org.geotools.referencing.datum.DefaultEllipsoid;

final class Spheroid
extends DefaultEllipsoid {
    private static final long serialVersionUID = 7867565381280669821L;

    protected Spheroid(Map properties, double radius, boolean ivfDefinitive, Unit unit) {
        super(properties, Spheroid.check("radius", radius), radius, Double.POSITIVE_INFINITY, ivfDefinitive, unit);
    }

    public double orthodromicDistance(double x1, double y1, double x2, double y2) {
        y1 = Math.toRadians(y1);
        y2 = Math.toRadians(y2);
        double dx = Math.toRadians(Math.abs(x2 - x1) % 360.0);
        double rho = Math.sin(y1) * Math.sin(y2) + Math.cos(y1) * Math.cos(y2) * Math.cos(dx);
        assert (Math.abs(rho) < 1.0000001) : rho;
        if (rho > 1.0) {
            rho = 1.0;
        }
        if (rho < -1.0) {
            rho = -1.0;
        }
        double distance = Math.acos(rho) * this.getSemiMajorAxis();
        try {
            double delta;
            assert ((delta = Math.abs(super.orthodromicDistance(x1, Math.toDegrees(y1), x2, Math.toDegrees(y2)) - distance)) < this.getSemiMajorAxis() / 1.0E9) : delta;
        }
        catch (ArithmeticException exception) {
            // empty catch block
        }
        return distance;
    }
}

