/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.AbstractCS;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class DefaultCompoundCS
extends AbstractCS {
    private static final long serialVersionUID = -5726410275278843372L;
    private final CoordinateSystem[] cs;
    private transient List asList;

    public DefaultCompoundCS(CoordinateSystem[] cs) {
        cs = DefaultCompoundCS.clone(cs);
        super(DefaultCompoundCS.getName(cs), DefaultCompoundCS.getAxis(cs));
        this.cs = cs;
    }

    private static CoordinateSystem[] clone(CoordinateSystem[] cs) {
        DefaultCompoundCS.ensureNonNull("cs", cs);
        cs = (CoordinateSystem[])cs.clone();
        for (int i = 0; i < cs.length; ++i) {
            DefaultCompoundCS.ensureNonNull("cs", cs, i);
        }
        return cs;
    }

    private static CoordinateSystemAxis[] getAxis(CoordinateSystem[] cs) {
        int count = 0;
        for (int i = 0; i < cs.length; ++i) {
            count += cs[i].getDimension();
        }
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[count];
        count = 0;
        for (int i = 0; i < cs.length; ++i) {
            CoordinateSystem c = cs[i];
            int dim = c.getDimension();
            for (int j = 0; j < dim; ++j) {
                axis[count++] = c.getAxis(j);
            }
        }
        assert (count == axis.length);
        return axis;
    }

    private static String getName(CoordinateSystem[] cs) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < cs.length; ++i) {
            if (buffer.length() != 0) {
                buffer.append(" / ");
            }
            buffer.append(cs[i].getName().getCode());
        }
        return buffer.toString();
    }

    public List getCoordinateSystems() {
        if (this.asList == null) {
            this.asList = Collections.unmodifiableList(Arrays.asList(this.cs));
        }
        return this.asList;
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultCompoundCS that = (DefaultCompoundCS)object;
            return DefaultCompoundCS.equals((IdentifiedObject[])this.cs, (IdentifiedObject[])that.cs, compareMetadata);
        }
        return false;
    }
}

