/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap.search;

import javax.naming.directory.SearchControls;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.util.Assert;

public class FilterBasedLdapUserSearch
implements LdapUserSearch {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ldap$search$FilterBasedLdapUserSearch == null ? (class$org$acegisecurity$ldap$search$FilterBasedLdapUserSearch = FilterBasedLdapUserSearch.class$("org.acegisecurity.ldap.search.FilterBasedLdapUserSearch")) : class$org$acegisecurity$ldap$search$FilterBasedLdapUserSearch));
    private InitialDirContextFactory initialDirContextFactory;
    private LdapUserDetailsMapper userDetailsMapper = new LdapUserDetailsMapper();
    private SearchControls searchControls = new SearchControls();
    private String searchBase = "";
    private String searchFilter;
    static /* synthetic */ Class class$org$acegisecurity$ldap$search$FilterBasedLdapUserSearch;

    public FilterBasedLdapUserSearch(String searchBase, String searchFilter, InitialDirContextFactory initialDirContextFactory) {
        Assert.notNull((Object)initialDirContextFactory, (String)"initialDirContextFactory must not be null");
        Assert.notNull((Object)searchFilter, (String)"searchFilter must not be null.");
        Assert.notNull((Object)searchBase, (String)"searchBase must not be null (an empty string is acceptable).");
        this.searchFilter = searchFilter;
        this.initialDirContextFactory = initialDirContextFactory;
        this.searchBase = searchBase;
        if (searchBase.length() == 0) {
            logger.info((Object)("SearchBase not set. Searches will be performed from the root: " + initialDirContextFactory.getRootDn()));
        }
    }

    public LdapUserDetails searchForUser(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for user '" + username + "', with user search " + this.toString()));
        }
        LdapTemplate template = new LdapTemplate(this.initialDirContextFactory);
        template.setSearchControls(this.searchControls);
        try {
            LdapUserDetailsImpl.Essence user = (LdapUserDetailsImpl.Essence)template.searchForSingleEntry(this.searchBase, this.searchFilter, new String[]{username}, this.userDetailsMapper);
            user.setUsername(username);
            return user.createUserDetails();
        }
        catch (IncorrectResultSizeDataAccessException notFound) {
            if (notFound.getActualSize() == 0) {
                throw new UsernameNotFoundException("User " + username + " not found in directory.");
            }
            throw notFound;
        }
    }

    public void setDerefLinkFlag(boolean deref) {
        this.searchControls.setDerefLinkFlag(deref);
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchControls.setSearchScope(searchSubtree ? 2 : 1);
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchControls.setTimeLimit(searchTimeLimit);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ searchFilter: '").append(this.searchFilter).append("', ");
        sb.append("searchBase: '").append(this.searchBase).append("'");
        sb.append(", scope: ").append(this.searchControls.getSearchScope() == 2 ? "subtree" : "single-level, ");
        sb.append("searchTimeLimit: ").append(this.searchControls.getTimeLimit());
        sb.append("derefLinkFlag: ").append(this.searchControls.getDerefLinkFlag()).append(" ]");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

