/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class CharsetUTF16
extends CharsetICU {
    protected byte[] fromUSubstitution = new byte[]{-1, -3};
    private static final byte[] UTF16BE_BOM = new byte[]{-2, -1};

    public CharsetUTF16(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        this.maxBytesPerChar = 2;
        this.minBytesPerChar = 2;
        this.maxCharsPerByte = 1.0f;
    }

    public CharsetDecoder newDecoder() {
        return new CharsetDecoderUTF16(this);
    }

    public CharsetEncoder newEncoder() {
        return new CharsetEncoderUTF16(this);
    }

    class CharsetEncoderUTF16
    extends CharsetEncoderICU {
        public CharsetEncoderUTF16(CharsetICU cs) {
            super(cs, CharsetUTF16.this.fromUSubstitution);
            this.implReset();
        }

        protected void implReset() {
            super.implReset();
            this.fromUnicodeStatus = 1;
            this.writeBOM = true;
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (!source.hasRemaining()) {
                return cr;
            }
            if (this.fromUnicodeStatus == 1 && this.writeBOM) {
                cr = CharsetEncoderUTF16.fromUWriteBytes(this, UTF16BE_BOM, 0, UTF16BE_BOM.length, target, offsets, -1);
                if (cr.isError()) {
                    return cr;
                }
                this.fromUnicodeStatus = 0;
            }
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int sourceIndex = 0;
            char trail = '\u0000';
            int length = source.remaining();
            int sourceArrayIndex = source.position();
            char c = (char)this.fromUChar32;
            if (c != '\u0000' && UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex))) && target.remaining() >= 4) {
                ++sourceArrayIndex;
                --length;
                target.put((byte)(c >>> 8));
                target.put((byte)c);
                target.put((byte)(trail >>> 8));
                target.put((byte)trail);
                if (offsets != null && offsets.remaining() >= 4) {
                    offsets.put(-1);
                    offsets.put(-1);
                    offsets.put(-1);
                    offsets.put(-1);
                }
                sourceIndex = 1;
                c = '\u0000';
                this.fromUChar32 = '\u0000';
            }
            byte[] overflow = new byte[4];
            if (c == '\u0000') {
                int count = 2 * length;
                int targetCapacity = target.remaining();
                if (count > targetCapacity) {
                    count = targetCapacity & 0xFFFFFFFE;
                }
                targetCapacity -= count;
                length -= (count >>= 1);
                if (offsets == null) {
                    while (count > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            target.put((byte)(c >>> 8));
                            target.put((byte)c);
                        } else {
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex)))) break;
                            ++sourceArrayIndex;
                            --count;
                            target.put((byte)(c >>> 8));
                            target.put((byte)c);
                            target.put((byte)(trail >>> 8));
                            target.put((byte)trail);
                        }
                        --count;
                    }
                } else {
                    while (count > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            target.put((byte)(c >>> 8));
                            target.put((byte)c);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex++);
                        } else {
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = source.get(sourceArrayIndex)))) break;
                            ++sourceArrayIndex;
                            --count;
                            target.put((byte)(c >>> 8));
                            target.put((byte)c);
                            target.put((byte)(trail >>> 8));
                            target.put((byte)trail);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            offsets.put(sourceIndex);
                            sourceIndex += 2;
                        }
                        --count;
                    }
                }
                if (count == 0) {
                    if (length > 0 && targetCapacity > 0) {
                        if (!UTF16.isSurrogate((char)(c = source.get(sourceArrayIndex++)))) {
                            overflow[0] = (byte)(c >>> 8);
                            overflow[1] = (byte)c;
                            length = 2;
                            c = '\u0000';
                        }
                    } else {
                        length = 0;
                        c = '\u0000';
                    }
                } else {
                    targetCapacity += 2 * count;
                }
            } else {
                length = 0;
            }
            if (c != '\u0000') {
                length = 0;
                if (UTF16.isLeadSurrogate((char)c)) {
                    if (sourceArrayIndex < source.limit()) {
                        trail = source.get(sourceArrayIndex);
                        if (UTF16.isTrailSurrogate((char)trail)) {
                            ++sourceArrayIndex;
                            overflow[0] = (byte)(c >>> 8);
                            overflow[1] = (byte)c;
                            overflow[2] = (byte)(trail >>> 8);
                            overflow[3] = (byte)trail;
                            length = 4;
                            c = '\u0000';
                        } else {
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                        }
                    }
                } else {
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                }
                this.fromUChar32 = c;
            }
            source.position(sourceArrayIndex);
            if (length > 0) {
                cr = CharsetEncoderUTF16.fromUWriteBytes(this, overflow, 0, length, target, offsets, sourceIndex);
            }
            return cr;
        }
    }

    class CharsetDecoderUTF16
    extends CharsetDecoderICU {
        ByteBuffer utf16BOM = ByteBuffer.wrap(new byte[]{-2, -1, 0, 0, -1, -2, 0, 0});

        public CharsetDecoderUTF16(CharsetICU cs) {
            super(cs);
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            ByteBuffer oldSource;
            int bomIndex;
            boolean oldFlush;
            CoderResult cr = CoderResult.UNDERFLOW;
            int offsetsPos = offsets == null ? 0 : offsets.position();
            this.utf16BOM.limit(this.utf16BOM.capacity());
            int offsetDelta = 0;
            int state = this.mode;
            int pos = source.position();
            block10: while (pos < source.limit()) {
                switch (state) {
                    case 0: {
                        byte b = source.get(pos);
                        if (b == -2) {
                            state = 1;
                        } else if (b == -1) {
                            state = 5;
                        } else {
                            state = 8;
                            continue block10;
                        }
                        ++pos;
                        break;
                    }
                    case 1: 
                    case 5: {
                        if (source.get(pos) == this.utf16BOM.get(state)) {
                            ++pos;
                            if (state == 1) {
                                state = 8;
                                offsetDelta = pos - source.position();
                                break;
                            }
                            if (state != 5) break;
                            state = 9;
                            offsetDelta = pos - source.position();
                            break;
                        }
                        if (pos != source.position()) {
                            pos = source.position();
                        } else {
                            oldFlush = flush;
                            bomIndex = state & 4;
                            oldSource = source;
                            source = this.utf16BOM;
                            this.utf16BOM.position(bomIndex);
                            source.limit(bomIndex + 1);
                            flush = false;
                            cr = this.decodeLoopUTF16BE(source, target, offsets, flush);
                            flush = oldFlush;
                            source = oldSource;
                        }
                        state = 8;
                        continue block10;
                    }
                    case 8: 
                    case 9: {
                        this.mode = state;
                        source.position(pos);
                        cr = this.decodeLoopImpl(source, target, offsets, flush);
                        pos = source.position();
                    }
                }
                if (!cr.isOverflow() && !cr.isError()) continue;
            }
            if (offsets != null && offsetDelta != 0) {
                int offsetsLimit = offsets.position();
                while (offsetsPos < offsetsLimit) {
                    int delta = offsetDelta + offsets.get(pos);
                    offsets.put(pos++, delta);
                }
            }
            source.position(pos);
            if (!source.hasRemaining() && flush) {
                switch (state) {
                    case 0: {
                        break;
                    }
                    case 8: {
                        cr = this.decodeLoopUTF16BE(source, target, offsets, flush);
                        break;
                    }
                    case 9: {
                        cr = this.decodeLoopUTF16LE(source, target, offsets, flush);
                        break;
                    }
                    default: {
                        oldFlush = flush;
                        bomIndex = state & 4;
                        oldSource = source;
                        source = this.utf16BOM;
                        this.utf16BOM.position(bomIndex);
                        source.limit(bomIndex + 1);
                        flush = false;
                        cr = this.decodeLoopUTF16BE(source, target, offsets, flush);
                        flush = oldFlush;
                        source = oldSource;
                        state = 8;
                    }
                }
            }
            this.mode = state;
            return cr;
        }

        protected CoderResult decodeLoopImpl(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult cr = CoderResult.UNDERFLOW;
            if (this.mode == 8) {
                cr = this.decodeLoopUTF16BE(source, target, offsets, flush);
            } else if (this.mode == 9) {
                cr = this.decodeLoopUTF16LE(source, target, offsets, flush);
            } else {
                throw new InternalError("Unknown State in UTF-16 converter!");
            }
            return cr;
        }

        final CoderResult decodeLoopUTF16BE(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            char trail;
            int sourceArrayIndex;
            int length;
            char c;
            int sourceIndex;
            CoderResult cr;
            block33: {
                int count;
                block32: {
                    block34: {
                        cr = CoderResult.UNDERFLOW;
                        if (!source.hasRemaining() && this.toUnicodeStatus == 0) {
                            return cr;
                        }
                        if (!target.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        sourceIndex = 0;
                        count = 0;
                        c = '\u0000';
                        length = source.remaining();
                        sourceArrayIndex = source.position();
                        if (this.toUnicodeStatus != 0) {
                            this.toUBytesArray[this.toUBytesBegin + 0] = (byte)this.toUnicodeStatus;
                            this.toULength = 1;
                            this.toUnicodeStatus = 0;
                        }
                        if ((count = this.toULength) != 0) {
                            byte[] pArray = this.toUBytesArray;
                            int pArrayIndex = this.toUBytesBegin;
                            do {
                                pArray[count++] = source.get(sourceArrayIndex++);
                                ++sourceIndex;
                                --length;
                                if (count == 2) {
                                    c = (char)((pArray[pArrayIndex + 0] & 0xFF) << 8 | pArray[pArrayIndex + 1] & 0xFF);
                                    if (!UTF16.isSurrogate((char)c)) {
                                        target.put(c);
                                        if (offsets != null) {
                                            offsets.put(-1);
                                        }
                                        count = 0;
                                        c = '\u0000';
                                        break;
                                    }
                                    if (!UTF16.isLeadSurrogate((char)c)) break;
                                    c = '\u0000';
                                    continue;
                                }
                                if (count != 4) continue;
                                c = (char)((pArray[pArrayIndex + 0] & 0xFF) << 8 | pArray[pArrayIndex + 1] & 0xFF);
                                trail = (char)((pArray[pArrayIndex + 2] & 0xFF) << 8 | pArray[pArrayIndex + 3] & 0xFF);
                                if (UTF16.isTrailSurrogate((char)trail)) {
                                    target.put(c);
                                    if (target.remaining() >= 1) {
                                        target.put(trail);
                                        if (offsets != null) {
                                            offsets.put(-1);
                                            offsets.put(-1);
                                        }
                                    } else {
                                        this.charErrorBufferArray[this.charErrorBufferBegin + 0] = trail;
                                        this.charErrorBufferLength = 1;
                                        return CoderResult.OVERFLOW;
                                    }
                                    count = 0;
                                    c = '\u0000';
                                    break;
                                }
                                if (source.position() - sourceArrayIndex >= 2) {
                                    sourceArrayIndex -= 2;
                                } else {
                                    this.toUnicodeStatus = 0x100 | pArray[pArrayIndex + 2];
                                    --sourceArrayIndex;
                                }
                                this.toULength = 2;
                                cr = CoderResult.malformedForLength(sourceArrayIndex);
                                break;
                            } while (length > 0);
                            this.toULength = (byte)count;
                        }
                        if ((count = 2 * target.remaining()) > length) {
                            count = length & 0xFFFFFFFE;
                        }
                        if (c != '\u0000' || count <= 0) break block33;
                        length -= count;
                        count >>= 1;
                        if (offsets != null) break block34;
                        do {
                            c = (char)((source.get(sourceArrayIndex + 0) & 0xFF) << 8 | source.get(sourceArrayIndex + 1) & 0xFF);
                            sourceArrayIndex += 2;
                            if (!UTF16.isSurrogate((char)c)) {
                                target.put(c);
                                continue;
                            }
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = (char)((source.get(sourceArrayIndex + 0) & 0xFF) << 8 | source.get(sourceArrayIndex + 1) & 0xFF)))) break block32;
                            sourceArrayIndex += 2;
                            --count;
                            target.put(c);
                            target.put(trail);
                        } while (--count > 0);
                        break block32;
                        {
                        }
                    }
                    do {
                        c = (char)((source.get(sourceArrayIndex + 0) & 0xFF) << 8 | source.get(sourceArrayIndex + 1) & 0xFF);
                        sourceArrayIndex += 2;
                        if (!UTF16.isSurrogate((char)c)) {
                            target.put(c);
                            offsets.put(sourceIndex);
                            sourceIndex += 2;
                            continue;
                        }
                        if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = (char)((source.get(sourceArrayIndex + 0) & 0xFF) << 8 | source.get(sourceArrayIndex + 1) & 0xFF)))) break;
                        sourceArrayIndex += 2;
                        --count;
                        target.put(c);
                        target.put(trail);
                        offsets.put(sourceIndex);
                        offsets.put(sourceIndex);
                        sourceIndex += 4;
                    } while (--count > 0);
                }
                if (count == 0) {
                    c = '\u0000';
                } else {
                    length += 2 * (count - 1);
                }
            }
            if (c != '\u0000') {
                this.toUBytesArray[this.toUBytesBegin + 0] = (byte)(c >>> 8);
                this.toUBytesArray[this.toUBytesBegin + 1] = (byte)c;
                this.toULength = 2;
                if (UTF16.isLeadSurrogate((char)c)) {
                    if (length >= 2) {
                        trail = (char)((source.get(sourceArrayIndex + 0) & 0xFF) << 8 | source.get(sourceArrayIndex + 1) & 0xFF);
                        if (UTF16.isTrailSurrogate((char)trail)) {
                            sourceArrayIndex += 2;
                            length -= 2;
                            target.put(c);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            this.charErrorBufferArray[this.charErrorBufferBegin + 0] = trail;
                            this.charErrorBufferLength = 1;
                            this.toULength = 0;
                            cr = CoderResult.OVERFLOW;
                        } else {
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                        }
                    }
                } else {
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                }
            }
            if (!cr.isError() && length > 0) {
                if (!target.hasRemaining()) {
                    cr = CoderResult.OVERFLOW;
                } else {
                    this.toUBytesArray[this.toULength++] = source.get(sourceArrayIndex++);
                }
            }
            source.position(sourceArrayIndex);
            return cr;
        }

        final CoderResult decodeLoopUTF16LE(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            char trail;
            int sourceArrayIndex;
            int length;
            char c;
            int sourceIndex;
            CoderResult cr;
            block33: {
                int count;
                block32: {
                    block34: {
                        cr = CoderResult.UNDERFLOW;
                        if (!source.hasRemaining() && this.toUnicodeStatus == 0) {
                            return cr;
                        }
                        if (!target.hasRemaining()) {
                            return CoderResult.OVERFLOW;
                        }
                        sourceIndex = 0;
                        count = 0;
                        c = '\u0000';
                        length = source.remaining();
                        sourceArrayIndex = source.position();
                        if (this.toUnicodeStatus != 0) {
                            this.toUBytesArray[this.toUBytesBegin + 0] = (byte)this.toUnicodeStatus;
                            this.toULength = 1;
                            this.toUnicodeStatus = 0;
                        }
                        if ((count = this.toULength) != 0) {
                            byte[] pArray = this.toUBytesArray;
                            int pArrayIndex = this.toUBytesBegin;
                            do {
                                pArray[count++] = source.get(sourceArrayIndex++);
                                ++sourceIndex;
                                --length;
                                if (count == 2) {
                                    c = (char)((pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 0] & 0xFF);
                                    if (!UTF16.isSurrogate((char)c)) {
                                        target.put(c);
                                        if (offsets != null) {
                                            offsets.put(-1);
                                        }
                                        count = 0;
                                        c = '\u0000';
                                        break;
                                    }
                                    if (!UTF16.isLeadSurrogate((char)c)) break;
                                    c = '\u0000';
                                    continue;
                                }
                                if (count != 4) continue;
                                c = (char)((pArray[pArrayIndex + 1] & 0xFF) << 8 | pArray[pArrayIndex + 0] & 0xFF);
                                trail = (char)((pArray[pArrayIndex + 3] & 0xFF) << 8 | pArray[pArrayIndex + 2] & 0xFF);
                                if (UTF16.isTrailSurrogate((char)trail)) {
                                    target.put(c);
                                    if (target.remaining() >= 1) {
                                        target.put(trail);
                                        if (offsets != null) {
                                            offsets.put(-1);
                                            offsets.put(-1);
                                        }
                                    } else {
                                        this.charErrorBufferArray[this.charErrorBufferBegin + 0] = trail;
                                        this.charErrorBufferLength = 1;
                                        return CoderResult.OVERFLOW;
                                    }
                                    count = 0;
                                    c = '\u0000';
                                    break;
                                }
                                if (source.position() - sourceArrayIndex >= 2) {
                                    sourceArrayIndex -= 2;
                                } else {
                                    this.toUnicodeStatus = 0x100 | pArray[pArrayIndex + 2];
                                    --sourceArrayIndex;
                                }
                                this.toULength = 2;
                                cr = CoderResult.malformedForLength(sourceArrayIndex);
                                break;
                            } while (length > 0);
                            this.toULength = (byte)count;
                        }
                        if ((count = 2 * target.remaining()) > length) {
                            count = length & 0xFFFFFFFE;
                        }
                        if (c != '\u0000' || count <= 0) break block33;
                        length -= count;
                        count >>= 1;
                        if (offsets != null) break block34;
                        do {
                            c = (char)((source.get(sourceArrayIndex + 1) & 0xFF) << 8 | source.get(sourceArrayIndex + 0) & 0xFF);
                            sourceArrayIndex += 2;
                            if (!UTF16.isSurrogate((char)c)) {
                                target.put(c);
                                continue;
                            }
                            if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = (char)((source.get(sourceArrayIndex + 1) & 0xFF) << 8 | source.get(sourceArrayIndex + 0) & 0xFF)))) break block32;
                            sourceArrayIndex += 2;
                            --count;
                            target.put(c);
                            target.put(trail);
                        } while (--count > 0);
                        break block32;
                        {
                        }
                    }
                    do {
                        c = (char)((source.get(sourceArrayIndex + 1) & 0xFF) << 8 | source.get(sourceArrayIndex + 0) & 0xFF);
                        sourceArrayIndex += 2;
                        if (!UTF16.isSurrogate((char)c)) {
                            target.put(c);
                            offsets.put(sourceIndex);
                            sourceIndex += 2;
                            continue;
                        }
                        if (!UTF16.isLeadSurrogate((char)c) || count < 2 || !UTF16.isTrailSurrogate((char)(trail = (char)((source.get(sourceArrayIndex + 1) & 0xFF) << 8 | source.get(sourceArrayIndex + 0) & 0xFF)))) break;
                        sourceArrayIndex += 2;
                        --count;
                        target.put(c);
                        target.put(trail);
                        offsets.put(sourceIndex);
                        offsets.put(sourceIndex);
                        sourceIndex += 4;
                    } while (--count > 0);
                }
                if (count == 0) {
                    c = '\u0000';
                } else {
                    length += 2 * (count - 1);
                }
            }
            if (c != '\u0000') {
                this.toUBytesArray[this.toUBytesBegin + 0] = (byte)c;
                this.toUBytesArray[this.toUBytesBegin + 1] = (byte)(c >>> 8);
                this.toULength = 2;
                if (UTF16.isLeadSurrogate((char)c)) {
                    if (length >= 2) {
                        trail = (char)((source.get(sourceArrayIndex + 1) & 0xFF) << 8 | source.get(sourceArrayIndex + 0) & 0xFF);
                        if (UTF16.isTrailSurrogate((char)trail)) {
                            sourceArrayIndex += 2;
                            length -= 2;
                            target.put(c);
                            if (offsets != null) {
                                offsets.put(sourceIndex);
                            }
                            this.charErrorBufferArray[this.charErrorBufferBegin + 0] = trail;
                            this.charErrorBufferLength = 1;
                            this.toULength = 0;
                            cr = CoderResult.OVERFLOW;
                        } else {
                            cr = CoderResult.malformedForLength(sourceArrayIndex);
                        }
                    }
                } else {
                    cr = CoderResult.malformedForLength(sourceArrayIndex);
                }
            }
            if (!cr.isError() && length > 0) {
                if (!target.hasRemaining()) {
                    cr = CoderResult.OVERFLOW;
                } else {
                    this.toUBytesArray[this.toULength++] = source.get(sourceArrayIndex++);
                }
            }
            source.position(sourceArrayIndex);
            return cr;
        }

        protected void implReset() {
            super.implReset();
        }
    }
}

