/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.awt.geom.GeneralPath;
import org.postgis.binary.ByteGetter;
import org.postgis.binary.ValueGetter;

public class ShapeBinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized int parse(String string, GeneralPath generalPath) {
        ByteGetter.StringByteGetter stringByteGetter = new ByteGetter.StringByteGetter(string);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(stringByteGetter), generalPath);
    }

    public synchronized int parse(byte[] byArray, GeneralPath generalPath) {
        ByteGetter.BinaryByteGetter binaryByteGetter = new ByteGetter.BinaryByteGetter(byArray);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(binaryByteGetter), generalPath);
    }

    protected int parseGeometry(ValueGetter valueGetter, GeneralPath generalPath) {
        byte by = valueGetter.getByte();
        if (by != valueGetter.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int n = valueGetter.getInt();
        int n2 = n & 0x1FFFFFFF;
        boolean bl = false;
        if ((n & Integer.MIN_VALUE) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        boolean bl3 = false;
        if ((n & 0x40000000) != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if ((n & 0x20000000) != 0) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        int n3 = -1;
        if (bl6) {
            n3 = valueGetter.getInt();
        }
        switch (n2) {
            case 1: {
                this.parsePoint(valueGetter, bl2, bl4, generalPath);
                break;
            }
            case 2: {
                this.parseLineString(valueGetter, bl2, bl4, generalPath);
                break;
            }
            case 3: {
                this.parsePolygon(valueGetter, bl2, bl4, generalPath);
                break;
            }
            case 4: {
                this.parseMultiPoint(valueGetter, generalPath);
                break;
            }
            case 5: {
                this.parseMultiLineString(valueGetter, generalPath);
                break;
            }
            case 6: {
                this.parseMultiPolygon(valueGetter, generalPath);
                break;
            }
            case 7: {
                this.parseCollection(valueGetter, generalPath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        return n3;
    }

    private final void parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        generalPath.moveTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
        generalPath.closePath();
        this.skipZM(valueGetter, bl, bl2);
    }

    private final void skipZM(ValueGetter valueGetter, boolean bl, boolean bl2) {
        if (bl) {
            valueGetter.getDouble();
        }
        if (bl2) {
            valueGetter.getDouble();
        }
    }

    private final void parseGeometryArray(ValueGetter valueGetter, int n, GeneralPath generalPath) {
        int n2 = 0;
        while (n2 < n) {
            this.parseGeometry(valueGetter, generalPath);
            ++n2;
        }
    }

    private final void parseCS(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        if (n > 0) {
            generalPath.moveTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
            this.skipZM(valueGetter, bl, bl2);
            int n2 = 1;
            while (n2 < n) {
                generalPath.lineTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
                this.skipZM(valueGetter, bl, bl2);
                ++n2;
            }
        }
    }

    private final void parseMultiPoint(ValueGetter valueGetter, GeneralPath generalPath) {
        this.parseGeometryArray(valueGetter, valueGetter.getInt(), generalPath);
    }

    private final void parseLineString(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
    }

    private final void parseLinearRing(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
        generalPath.closePath();
    }

    private final void parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n = valueGetter.getInt() - 1;
        this.parseLinearRing(valueGetter, bl, bl2, generalPath);
        int n2 = 0;
        while (n2 < n) {
            this.parseLinearRing(valueGetter, bl, bl2, generalPath);
            ++n2;
        }
    }

    private final void parseMultiLineString(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }

    private final void parseMultiPolygon(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }

    private final void parseCollection(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }
}

