/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.street;

import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.domain.valueobject.Pagination;
import com.gisgraphy.geoloc.GeolocQuery;
import com.gisgraphy.street.StreetSearchException;
import com.gisgraphy.street.StreetSearchMode;
import com.gisgraphy.street.StreetType;
import com.vividsolutions.jts.geom.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreetSearchQuery
extends GeolocQuery {
    public static final String STREETTYPE_PARAMETER = "streettype";
    public static final String ONEWAY_PARAMETER = "oneway";
    public static final String NAME_PARAMETER = "name";
    public static final int DEFAULT_MAX_RESULTS = 50;
    public static final int NAME_MAX_LENGTH = 200;
    private StreetType streetType = null;
    private String name = null;
    private Boolean oneWay = null;
    private StreetSearchMode streetSearchMode = StreetSearchMode.getDefault();

    public StreetSearchQuery(Point point, double radius, Pagination pagination, Output output, Class<?> placeType) {
        this.withPagination(pagination);
        this.withOutput(output);
        this.point = point;
        this.withRadius(radius);
        this.withPlaceType(placeType);
    }

    public StreetSearchQuery(Point point, double radius) {
        this.point = point;
        this.withRadius(radius);
    }

    public StreetSearchQuery(Point point) {
        this.point = point;
    }

    public StreetSearchQuery(String name) {
        this.name = name;
    }

    public StreetSearchQuery(Point point, double radius, Pagination pagination, Output output, StreetType streetType, Boolean oneWay, String name, StreetSearchMode streetSearchMode) {
        super(point, radius, pagination, output, null);
        this.withStreetType(streetType).withName(name).withOneWay(oneWay);
        if (name != null && streetSearchMode == null) {
            this.withStreetSearchMode(StreetSearchMode.getDefault());
        } else {
            this.withStreetSearchMode(streetSearchMode);
        }
    }

    public StreetSearchQuery(Point point, double radius, StreetType streetType) {
        super(point, radius);
        this.withStreetType(streetType);
    }

    public StreetSearchQuery(Point point, StreetType streetType) {
        super(point);
        this.withStreetType(streetType);
    }

    public StreetType getStreetType() {
        return this.streetType;
    }

    public StreetSearchQuery withStreetType(StreetType streetType) {
        this.streetType = streetType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public StreetSearchQuery withName(String name) {
        if (name == null || "".equals(name.trim())) {
            return this;
        }
        if (name.length() > 200) {
            throw new StreetSearchException("name is limited to 200characters");
        }
        this.name = name;
        return this;
    }

    public StreetSearchQuery withOneWay(Boolean oneWay) {
        this.oneWay = oneWay;
        return this;
    }

    @Override
    public int getMaxLimitResult() {
        return 50;
    }

    public Boolean getOneWay() {
        return this.oneWay;
    }

    public StreetSearchMode getStreetSearchMode() {
        return this.streetSearchMode;
    }

    public StreetSearchQuery withStreetSearchMode(StreetSearchMode streetSearchMode) {
        this.streetSearchMode = streetSearchMode;
        return this;
    }

    @Override
    public String toString() {
        Double lat = this.getPoint() == null ? null : Double.valueOf(this.getPoint().getY());
        Double lng = this.getPoint() == null ? null : Double.valueOf(this.getPoint().getY());
        String asString = "StreetSearchQuery (lat='" + lat + "',long='" + lng + "') with apikey=" + this.getApikey() + " and name=" + this.name + " and streetsearchmode=" + (Object)((Object)this.streetSearchMode) + " and radius=" + this.getRadius() + " for streetType=" + (Object)((Object)this.streetType) + " and oneWay=" + this.oneWay;
        asString = asString + " with " + this.getOutput() + " and " + this.pagination + " and distance = " + this.hasDistanceField();
        return asString;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.oneWay == null ? 0 : this.oneWay.hashCode());
        result = 31 * result + (this.streetSearchMode == null ? 0 : this.streetSearchMode.hashCode());
        result = 31 * result + (this.streetType == null ? 0 : this.streetType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreetSearchQuery other = (StreetSearchQuery)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.oneWay == null ? other.oneWay != null : !this.oneWay.equals(other.oneWay)) {
            return false;
        }
        if (this.streetSearchMode == null ? other.streetSearchMode != null : !this.streetSearchMode.equals((Object)other.streetSearchMode)) {
            return false;
        }
        return !(this.streetType == null ? other.streetType != null : !this.streetType.equals((Object)other.streetType));
    }
}

