/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import com.vividsolutions.jts.geom.Point;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLUtils {
    public static final String GOOGLE_MAP_BASE_URL = "http://maps.google.com/maps?f=q&amp;ie=UTF-8&amp;iwloc=addr&amp;om=1&amp;z=12&amp;q=";
    public static final String DEFAULT_GOOGLE_MAP_BASE_URL = "http://maps.google.com/maps?f=q&amp;ie=UTF-8&amp;iwloc=addr&amp;om=1&amp;z=1&amp;q=";
    public static final String YAHOO_MAP_BASE_URL = "http://maps.yahoo.com/broadband?mag=6&amp;mvt=m";
    public static final String DEFAULT_YAHOO_MAP_BASE_URL = "http://maps.yahoo.com/";
    public static final String COUNTRY_FLAG_BASE_URL = "/images/flags/";
    public static final String DEFAULT_COUNTRY_FLAG_URL = "/images/flags/default.png";

    public static String createGoogleMapUrl(Point point, String label) {
        if (point == null) {
            return DEFAULT_GOOGLE_MAP_BASE_URL;
        }
        try {
            StringBuffer sb = new StringBuffer(GOOGLE_MAP_BASE_URL);
            sb.append(URLEncoder.encode(label == null ? "" : label, "UTF-8")).append("&amp;ll=").append(point.getY() + 0.03).append(",").append(point.getX());
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            return DEFAULT_GOOGLE_MAP_BASE_URL;
        }
    }

    public static String createYahooMapUrl(Point point) {
        if (point == null) {
            return DEFAULT_YAHOO_MAP_BASE_URL;
        }
        StringBuffer sb = new StringBuffer(YAHOO_MAP_BASE_URL);
        sb.append("&amp;lon=").append(point.getX()).append("&amp;lat=").append(point.getY());
        return sb.toString();
    }

    public static String createCountryFlagUrl(String countryCode) {
        if (countryCode == null) {
            return DEFAULT_COUNTRY_FLAG_URL;
        }
        StringBuffer sb = new StringBuffer(COUNTRY_FLAG_BASE_URL);
        sb.append(countryCode.toUpperCase()).append(".png");
        return sb.toString();
    }
}

