/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.geoloc;

import com.gisgraphy.domain.valueobject.GisgraphyConfig;
import com.gisgraphy.domain.valueobject.Output;
import com.gisgraphy.domain.valueobject.Pagination;
import com.gisgraphy.service.AbstractGisQuery;
import com.vividsolutions.jts.geom.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeolocQuery
extends AbstractGisQuery {
    public static final String PLACETYPE_PARAMETER = "placetype";
    public static final String LAT_PARAMETER = "lat";
    public static final String LONG_PARAMETER = "lng";
    public static final String RADIUS_PARAMETER = "radius";
    public static final String DISTANCE_PARAMETER = "distance";
    public static final String CALLBACK_PARAMETER = "callback";
    public static final int DEFAULT_MAX_RESULTS = 10;
    private Class<?> placeType = GisgraphyConfig.defaultGeolocSearchPlaceTypeClass;
    public static final double DEFAULT_RADIUS = 10000.0;
    protected Point point;
    private double radius = 10000.0;
    private boolean distanceField = true;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.placeType == null ? 0 : this.placeType.hashCode());
        result = 31 * result + (this.point == null ? 0 : this.point.hashCode());
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeolocQuery other = (GeolocQuery)obj;
        if (this.placeType == null ? other.placeType != null : !this.placeType.equals(other.placeType)) {
            return false;
        }
        if (this.point == null) {
            if (other.point != null) {
                return false;
            }
        } else {
            if (this.point.getX() != other.point.getX()) {
                return false;
            }
            if (this.point.getY() != other.point.getY()) {
                return false;
            }
        }
        return Double.doubleToLongBits(this.radius) == Double.doubleToLongBits(other.radius);
    }

    protected GeolocQuery() {
    }

    public GeolocQuery(Point point, double radius, Pagination pagination, Output output, Class<?> placeType) {
        super(pagination, output);
        if (point == null) {
            throw new IllegalArgumentException("point(lat and long) must not be null");
        }
        this.point = point;
        this.withRadius(radius);
        this.withPlaceType(placeType);
    }

    public GeolocQuery(Point point, double radius) {
        this(point, radius, null, null, GisgraphyConfig.defaultGeolocSearchPlaceTypeClass);
    }

    public Double getLatitude() {
        Double latitude = null;
        if (this.point != null) {
            latitude = this.point.getY();
        }
        return latitude;
    }

    public Double getLongitude() {
        Double longitude = null;
        if (this.point != null) {
            longitude = this.point.getX();
        }
        return longitude;
    }

    public GeolocQuery(Point point) {
        this(point, 10000.0, null, null, GisgraphyConfig.defaultGeolocSearchPlaceTypeClass);
    }

    public Point getPoint() {
        return this.point;
    }

    public GeolocQuery withRadius(double radius) {
        this.radius = radius <= 0.0 ? 10000.0 : radius;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isOutputIndented() {
        return this.output.isIndented();
    }

    @Override
    public String toString() {
        String asString = "GeolocQuery with apikey=" + this.getApikey() + " and (lat='" + this.point.getY() + "',long='" + this.point.getX() + "') and radius=" + this.radius + " for ";
        asString = this.placeType == null ? asString + "all placeType" : asString + this.placeType.getSimpleName();
        asString = asString + " with " + this.getOutput() + " and " + this.pagination + " and distance = " + this.distanceField;
        return asString;
    }

    public Class<?> getPlaceType() {
        return this.placeType;
    }

    public GeolocQuery withPlaceType(Class<?> placeType) {
        this.placeType = placeType;
        return this;
    }

    @Override
    public int getMaxLimitResult() {
        return 10;
    }

    public boolean hasDistanceField() {
        return this.distanceField;
    }

    public GeolocQuery withDistanceField(boolean distanceField) {
        this.distanceField = distanceField;
        return this;
    }
}

