/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

public class Pagination {
    public static final int DEFAULT_MAX_RESULTS = 10;
    public int maxResult = 10;
    public static final int DEFAULT_FROM = 1;
    public static final Pagination DEFAULT_PAGINATION = new Pagination();
    public static final Pagination ONE_RESULT = new Pagination().from(1).to(1);
    private int from = 1;
    private int to = 10;

    private Pagination() {
    }

    public static FromSpecification paginate() {
        return new PaginationBuilder();
    }

    public static FromSpecification paginateWithMaxResults(int maxResult) {
        PaginationBuilder builder = new PaginationBuilder();
        if (maxResult <= 0) {
            builder.maxResults = 10;
        } else {
            builder.maxResults = maxResult;
        }
        return builder;
    }

    private Pagination from(int from) {
        this.from = from > 0 ? from : 1;
        return this;
    }

    private Pagination to(int to) {
        this.to = to > 0 && to >= this.from ? to : this.from + this.maxResult - 1;
        return this;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Pagination limitNumberOfResults(int limit) {
        if (limit > 0) {
            this.to = this.getMaxNumberOfResults() > limit ? this.from + limit - 1 : this.to;
        }
        return this;
    }

    public int getMaxNumberOfResults() {
        return this.to - this.from + 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from;
        result = 31 * result + this.to;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pagination other = (Pagination)obj;
        if (this.from != other.from) {
            return false;
        }
        return this.to == other.to;
    }

    public String toString() {
        return "paginate from " + this.from + " to " + this.to;
    }

    public static class PaginationBuilder
    implements FromSpecification,
    ToSpecification {
        private int from;
        private int to;
        private int maxResults = 10;

        private PaginationBuilder() {
        }

        private Pagination build() {
            Pagination pagination = new Pagination();
            pagination.maxResult = this.maxResults;
            pagination.from(this.from).to(this.to);
            return pagination;
        }

        public Pagination to(int to) {
            this.to = to;
            return this.build();
        }

        public ToSpecification from(int from) {
            this.from = from;
            return this;
        }
    }

    public static interface FromSpecification {
        public ToSpecification from(int var1);
    }

    public static interface ToSpecification {
        public Pagination to(int var1);
    }
}

