/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

import com.gisgraphy.serializer.common.OutputFormat;

public class Output {
    public static final String DEFAULT_LANGUAGE_CODE = null;
    public static final boolean DEFAULT_INDENTATION = false;
    private OutputFormat format = OutputFormat.getDefault();
    private String languageCode = DEFAULT_LANGUAGE_CODE;
    private OutputStyle style = OutputStyle.MEDIUM;
    private boolean indent = false;
    public static final Output DEFAULT_OUTPUT = Output.withFormat(OutputFormat.XML).withStyle(OutputStyle.MEDIUM).withLanguageCode(DEFAULT_LANGUAGE_CODE);

    private Output(OutputFormat format) {
        this.format = format == null ? OutputFormat.getDefault() : format;
    }

    public static Output withFormat(OutputFormat format) {
        return new Output(format);
    }

    public static Output withDefaultFormat() {
        return new Output(OutputFormat.getDefault());
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public OutputStyle getStyle() {
        return this.style;
    }

    public boolean isIndented() {
        return this.indent;
    }

    public Output withIndentation() {
        this.indent = true;
        return this;
    }

    public Output withLanguageCode(String languageCode) {
        this.languageCode = languageCode == null || "".equals(languageCode.trim()) ? DEFAULT_LANGUAGE_CODE : languageCode.toUpperCase();
        return this;
    }

    public Output withStyle(OutputStyle style) {
        this.style = style == null ? OutputStyle.MEDIUM : style;
        return this;
    }

    public String toString() {
        return "output in " + this.format + ", in " + (Object)((Object)this.style) + " style with language " + this.languageCode + " and ident=" + this.isIndented();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.indent ? 1231 : 1237);
        result = 31 * result + (this.languageCode == null ? 0 : this.languageCode.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Output other = (Output)obj;
        if (this.format == null ? other.format != null : !this.format.equals((Object)other.format)) {
            return false;
        }
        if (this.indent != other.indent) {
            return false;
        }
        if (this.languageCode == null ? other.languageCode != null : !this.languageCode.equals(other.languageCode)) {
            return false;
        }
        return !(this.style == null ? other.style != null : !this.style.equals((Object)other.style));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputStyle {
        SHORT,
        MEDIUM,
        LONG,
        FULL;


        public static OutputStyle getDefault() {
            return MEDIUM;
        }

        public static OutputStyle getFromString(String style) {
            OutputStyle outputStyle = OutputStyle.getDefault();
            try {
                outputStyle = OutputStyle.valueOf(style.toUpperCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return outputStyle;
        }
    }
}

