/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GisgraphyConfig {
    public static Logger logger = LoggerFactory.getLogger(GisgraphyConfig.class);
    public static final String ENTITY_PACKAGE = "com.gisgraphy.domain.geoloc.entity.";
    public static Class<?> defaultGeolocSearchPlaceTypeClass = null;
    public static String googleMapAPIKey;
    public boolean useAddressParserWhenGeocoding = false;
    public static boolean searchForExactMatchWhenGeocoding;
    public static String googleanalytics_uacctcode;
    public static final String ENVIRONEMENT_PROPERTIES_FILE = "env";
    public static boolean PARTIAL_SEARH_EXPERIMENTAL;
    public static boolean STREET_SEARCH_FULLTEXT_MODE;

    public void setDefaultGeolocSearchPlaceType(String defaultGeolocSearchPlaceType) {
        if (defaultGeolocSearchPlaceType == null || defaultGeolocSearchPlaceType.trim().length() == 0) {
            defaultGeolocSearchPlaceTypeClass = null;
        }
        try {
            Class<?> clazz = Class.forName(ENTITY_PACKAGE + defaultGeolocSearchPlaceType);
            defaultGeolocSearchPlaceTypeClass = clazz;
            logger.info("defaultGeolocSearchPlaceType" + defaultGeolocSearchPlaceTypeClass);
        }
        catch (ClassNotFoundException e) {
            logger.warn("can not set defaultGeolocSearchPlaceTypeClass with " + defaultGeolocSearchPlaceType + " : " + e.getMessage());
            defaultGeolocSearchPlaceTypeClass = null;
        }
    }

    public void setGoogleMapAPIKey(String googleMapAPIKey) {
        if (googleMapAPIKey == null || "".equals(googleMapAPIKey.trim())) {
            logger.warn("googleMapAPIKey is not set, please set it in env.properties file and re-launch Gisgraphy, if you want to use google maps functionnalities, ");
        } else {
            logger.info("set googleMapAPIKey to " + googleMapAPIKey);
        }
        GisgraphyConfig.googleMapAPIKey = googleMapAPIKey;
    }

    public void setGoogleanalytics_uacctcode(String code) {
        if (code == null || "".equals(code.trim())) {
            logger.warn("googleanalytics_uacctcode is not set, please set it in env.properties file and re-launch Gisgraphy, if you want to use google analytics functionnalities, ");
        } else {
            logger.info("set googleanalytics_uacctcode to " + code);
        }
        googleanalytics_uacctcode = code;
    }

    public boolean isUseAddressParserWhenGeocoding() {
        return this.useAddressParserWhenGeocoding;
    }

    public void setUseAddressParserWhenGeocoding(boolean useAddressParserWhenGeocoding) {
        this.useAddressParserWhenGeocoding = useAddressParserWhenGeocoding;
    }

    public boolean isSearchForExactMatchWhenGeocoding() {
        return searchForExactMatchWhenGeocoding;
    }

    public void setSearchForExactMatchWhenGeocoding(boolean searchForExactMatchWhenGeocoding) {
        GisgraphyConfig.searchForExactMatchWhenGeocoding = searchForExactMatchWhenGeocoding;
    }

    static {
        searchForExactMatchWhenGeocoding = false;
        PARTIAL_SEARH_EXPERIMENTAL = false;
        STREET_SEARCH_FULLTEXT_MODE = false;
    }
}

