/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.domain.valueobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CountriesStaticData {
    public static final Map<String, String> countriesnameToCountryCodeMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 4762318033721437587L;
        {
            this.put("Afghanistan", "AF");
            this.put("Aland Islands", "AX");
            this.put("Albania", "AL");
            this.put("Algeria", "DZ");
            this.put("American Samoa", "AS");
            this.put("Andorra", "AD");
            this.put("Angola", "AO");
            this.put("Anguilla", "AI");
            this.put("Antarctica", "AQ");
            this.put("Antigua and Barbuda", "AG");
            this.put("Argentina", "AR");
            this.put("Armenia", "AM");
            this.put("Aruba", "AW");
            this.put("Australia", "AU");
            this.put("Austria", "AT");
            this.put("Azerbaijan", "AZ");
            this.put("Bahamas", "BS");
            this.put("Bahrain", "BH");
            this.put("Bangladesh", "BD");
            this.put("Barbados", "BB");
            this.put("Belarus", "BY");
            this.put("Belgium", "BE");
            this.put("Belize", "BZ");
            this.put("Benin", "BJ");
            this.put("Bermuda", "BM");
            this.put("Bhutan", "BT");
            this.put("Bolivia", "BO");
            this.put("Bosnia and Herzegovina", "BA");
            this.put("Botswana", "BW");
            this.put("Bouvet Island", "BV");
            this.put("Brazil", "BR");
            this.put("British Indian Ocean Territory", "IO");
            this.put("British Virgin Islands", "VG");
            this.put("Brunei", "BN");
            this.put("Bulgaria", "BG");
            this.put("Burkina Faso", "BF");
            this.put("Burundi", "BI");
            this.put("Cambodia", "KH");
            this.put("Cameroon", "CM");
            this.put("Canada", "CA");
            this.put("Cape Verde", "CV");
            this.put("Cayman Islands", "KY");
            this.put("Central African Republic", "CF");
            this.put("Chad", "TD");
            this.put("Chile", "CL");
            this.put("China", "CN");
            this.put("Christmas Island", "CX");
            this.put("Cocos Islands", "CC");
            this.put("Colombia", "CO");
            this.put("Comoros", "KM");
            this.put("Cook Islands", "CK");
            this.put("Costa Rica", "CR");
            this.put("Croatia", "HR");
            this.put("Cuba", "CU");
            this.put("Cyprus", "CY");
            this.put("Czech Republic", "CZ");
            this.put("Democratic Republic of the Congo", "CD");
            this.put("Denmark", "DK");
            this.put("Djibouti", "DJ");
            this.put("Dominica", "DM");
            this.put("Dominican Republic", "DO");
            this.put("East Timor", "TL");
            this.put("Ecuador", "EC");
            this.put("Egypt", "EG");
            this.put("El Salvador", "SV");
            this.put("Equatorial Guinea", "GQ");
            this.put("Eritrea", "ER");
            this.put("Estonia", "EE");
            this.put("Ethiopia", "ET");
            this.put("Falkland Islands", "FK");
            this.put("Faroe Islands", "FO");
            this.put("Fiji", "FJ");
            this.put("Finland", "FI");
            this.put("France", "FR");
            this.put("French Guiana", "GF");
            this.put("French Polynesia", "PF");
            this.put("French Southern Territories", "TF");
            this.put("Gabon", "GA");
            this.put("Gambia", "GM");
            this.put("Georgia", "GE");
            this.put("Germany", "DE");
            this.put("Ghana", "GH");
            this.put("Gibraltar", "GI");
            this.put("Greece", "GR");
            this.put("Greenland", "GL");
            this.put("Grenada", "GD");
            this.put("Guadeloupe", "GP");
            this.put("Guam", "GU");
            this.put("Guatemala", "GT");
            this.put("Guernsey", "GG");
            this.put("Guinea", "GN");
            this.put("Guinea-Bissau", "GW");
            this.put("Guyana", "GY");
            this.put("Haiti", "HT");
            this.put("Heard Island and McDonald Islands", "HM");
            this.put("Honduras", "HN");
            this.put("Hong Kong", "HK");
            this.put("Hungary", "HU");
            this.put("Iceland", "IS");
            this.put("India", "IN");
            this.put("Indonesia", "ID");
            this.put("Iran", "IR");
            this.put("Iraq", "IQ");
            this.put("Ireland", "IE");
            this.put("Isle of Man", "IM");
            this.put("Israel", "IL");
            this.put("Italy", "IT");
            this.put("Ivory Coast", "CI");
            this.put("Jamaica", "JM");
            this.put("Japan", "JP");
            this.put("Jersey", "JE");
            this.put("Jordan", "JO");
            this.put("Kazakhstan", "KZ");
            this.put("Kenya", "KE");
            this.put("Kiribati", "KI");
            this.put("Kosovo", "XK");
            this.put("Kuwait", "KW");
            this.put("Kyrgyzstan", "KG");
            this.put("Laos", "LA");
            this.put("Latvia", "LV");
            this.put("Lebanon", "LB");
            this.put("Lesotho", "LS");
            this.put("Liberia", "LR");
            this.put("Libya", "LY");
            this.put("Liechtenstein", "LI");
            this.put("Lithuania", "LT");
            this.put("Luxembourg", "LU");
            this.put("Macao", "MO");
            this.put("Macedonia", "MK");
            this.put("Madagascar", "MG");
            this.put("Malawi", "MW");
            this.put("Malaysia", "MY");
            this.put("Maldives", "MV");
            this.put("Mali", "ML");
            this.put("Malta", "MT");
            this.put("Marshall Islands", "MH");
            this.put("Martinique", "MQ");
            this.put("Mauritania", "MR");
            this.put("Mauritius", "MU");
            this.put("Mayotte", "YT");
            this.put("Mexico", "MX");
            this.put("Micronesia", "FM");
            this.put("Moldova", "MD");
            this.put("Monaco", "MC");
            this.put("Mongolia", "MN");
            this.put("Montenegro", "ME");
            this.put("Montserrat", "MS");
            this.put("Morocco", "MA");
            this.put("Mozambique", "MO");
            this.put("Myanmar", "MM");
            this.put("Namibia", "NA");
            this.put("Nauru", "NR");
            this.put("Nepal", "NP");
            this.put("Netherlands", "NL");
            this.put("Netherlands Antilles", "AN");
            this.put("New Caledonia", "NC");
            this.put("New Zealand", "NZ");
            this.put("Nicaragua", "NI");
            this.put("Niger", "NE");
            this.put("Nigeria", "NG");
            this.put("Niue", "NU");
            this.put("Norfolk Island", "NF");
            this.put("Northern Mariana Islands", "MP");
            this.put("North Korea", "KP");
            this.put("Norway", "NO");
            this.put("Oman", "OM");
            this.put("Pakistan", "PK");
            this.put("Palau", "PW");
            this.put("Palestinian Territory", "PS");
            this.put("Panama", "PA");
            this.put("Papua New Guinea", "PG");
            this.put("Paraguay", "PY");
            this.put("Peru", "PE");
            this.put("Philippines", "PH");
            this.put("Pitcairn", "PN");
            this.put("Poland", "PL");
            this.put("Portugal", "PT");
            this.put("Puerto Rico", "PR");
            this.put("Qatar", "QA");
            this.put("Republic of the Congo", "CG");
            this.put("Reunion", "RE");
            this.put("Romania", "RO");
            this.put("Russia", "RU");
            this.put("Rwanda", "RW");
            this.put("Saint Barth\u00e9lemy", "BL");
            this.put("Saint Helena", "SH");
            this.put("Saint Kitts and Nevis", "KN");
            this.put("Saint Lucia", "LC");
            this.put("Saint Martin", "MF");
            this.put("Saint Pierre and Miquelon", "PM");
            this.put("Saint Vincent and the Grenadines", "VC");
            this.put("Samoa", "WS");
            this.put("San Marino", "SM");
            this.put("Sao Tome and Principe", "ST");
            this.put("Saudi Arabia", "SA");
            this.put("Senegal", "SN");
            this.put("Serbia", "RS");
            this.put("Serbia and Montenegro", "CS");
            this.put("Seychelles", "SC");
            this.put("Sierra Leone", "SL");
            this.put("Singapore", "SG");
            this.put("Slovakia", "SK");
            this.put("Slovenia", "SI");
            this.put("Solomon Islands", "SB");
            this.put("Somalia", "SO");
            this.put("South Africa", "ZA");
            this.put("South Georgia and the South Sandwich Islands", "GS");
            this.put("South Korea", "KR");
            this.put("Spain", "ES");
            this.put("Sri Lanka", "LK");
            this.put("Sudan", "SD");
            this.put("Suriname", "SR");
            this.put("Svalbard and Jan Mayen", "SJ");
            this.put("Swaziland", "SZ");
            this.put("Sweden", "SE");
            this.put("Switzerland", "CH");
            this.put("Syria", "SY");
            this.put("Taiwan", "TW");
            this.put("Tajikistan", "TJ");
            this.put("Tanzania", "TZ");
            this.put("Thailand", "TH");
            this.put("Togo", "TG");
            this.put("Tokelau", "TK");
            this.put("Tonga", "TO");
            this.put("Trinidad and Tobago", "TT");
            this.put("Tunisia", "TN");
            this.put("Turkey", "TR");
            this.put("Turkmenistan", "TM");
            this.put("Turks and Caicos Islands", "TC");
            this.put("Tuvalu", "TV");
            this.put("Uganda", "UG");
            this.put("Ukraine", "UA");
            this.put("United Arab Emirates", "AE");
            this.put("United Kingdom", "GB");
            this.put("United States", "US");
            this.put("United States Minor Outlying Islands", "UM");
            this.put("Uruguay", "UY");
            this.put("U.S. Virgin Islands", "VI");
            this.put("Uzbekistan", "UZ");
            this.put("Vanuatu", "VU");
            this.put("Vatican", "VA");
            this.put("Venezuela", "VE");
            this.put("Vietnam", "VN");
            this.put("Wallis and Futuna", "WF");
            this.put("Western Sahara", "EH");
            this.put("Yemen", "YE");
            this.put("Zambia", "ZM");
            this.put("Zimbabwe", "ZW");
        }
    };
    public static ArrayList<String> sortedCountriesName = new ArrayList<String>(countriesnameToCountryCodeMap.keySet()){
        private static final long serialVersionUID = 1671688713929233996L;
        {
            Collections.sort(this);
        }
    };

    public static int getNumberOfCountries() {
        return sortedCountriesName.size();
    }

    public static String getCountryCodeFromCountryName(String countryname) {
        return countriesnameToCountryCodeMap.get(countryname);
    }

    public static String getCountryCodeFromPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position should be positive or null");
        }
        return CountriesStaticData.getCountryCodeFromCountryName(CountriesStaticData.getCountryNameFromPosition(position));
    }

    public static String getCountryNameFromPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position should be positive or null");
        }
        return sortedCountriesName.get(position);
    }

    public static String getCountryNameFromCountryCode(String countryCode) {
        for (Map.Entry<String, String> entry : countriesnameToCountryCodeMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(countryCode)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static int getPositionFromCountryCode(String countryCode) {
        int position = 0;
        String countryNameToSearch = CountriesStaticData.getCountryNameFromCountryCode(countryCode);
        for (String country : sortedCountriesName) {
            if (country.equalsIgnoreCase(countryNameToSearch)) {
                return position;
            }
            ++position;
        }
        return 0;
    }
}

