/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser;

import com.gisgraphy.addressparser.GeocodingLevels;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="address")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Address {
    private Long id;
    private Double lng;
    private Double lat;
    private GeocodingLevels geocodingLevel = GeocodingLevels.NONE;
    private String name;
    private String recipientName;
    private String houseNumber;
    private String houseNumberInfo;
    private String POBox;
    private String POBoxInfo;
    private String POBoxAgency;
    private String civicNumberSuffix;
    private String preDirection;
    private String streetName;
    private String streetType;
    private String postDirection;
    private String preDirectionIntersection;
    private String streetNameIntersection;
    private String StreetTypeIntersection;
    private String postDirectionIntersection;
    private String extraInfo;
    private String floor;
    private String quarter;
    private String zipCode;
    private String district;
    private String dependentLocality;
    private String city;
    private String postTown;
    private String state;
    private String country;
    private String countryCode;
    private String sector;
    private String quadrant;
    private String block;
    private String PostOfficeBox;

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return this.lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public String getStreetNameIntersection() {
        return this.streetNameIntersection;
    }

    public void setStreetNameIntersection(String streetNameIntersection) {
        this.streetNameIntersection = streetNameIntersection;
    }

    public String getStreetTypeIntersection() {
        return this.StreetTypeIntersection;
    }

    public void setStreetTypeIntersection(String streetTypeIntersection) {
        this.StreetTypeIntersection = streetTypeIntersection;
    }

    public String getStreetType() {
        return this.streetType;
    }

    public void setStreetType(String streetType) {
        this.streetType = streetType;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(String extraInfo) {
        if (extraInfo != null && !"".equals(extraInfo.trim())) {
            this.extraInfo = extraInfo;
        }
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public void setHouseNumber(String houseNumber) {
        this.houseNumber = houseNumber;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(String quadrant) {
        this.quadrant = quadrant;
    }

    public String getBlock() {
        return this.block;
    }

    public void setBlock(String block) {
        this.block = block;
    }

    public String getHouseNumberInfo() {
        return this.houseNumberInfo;
    }

    public void setHouseNumberInfo(String houseNumberInfo) {
        this.houseNumberInfo = houseNumberInfo;
    }

    public String getPreDirection() {
        return this.preDirection;
    }

    public void setPredirection(String preDirection) {
        this.preDirection = preDirection;
    }

    public String getPostDirection() {
        return this.postDirection;
    }

    public void setPostDirection(String postDirection) {
        this.postDirection = postDirection;
    }

    public String getPreDirectionIntersection() {
        return this.preDirectionIntersection;
    }

    public void setPredirectionIntersection(String preDirectionIntersection) {
        this.preDirectionIntersection = preDirectionIntersection;
    }

    public String getPostDirectionIntersection() {
        return this.postDirectionIntersection;
    }

    public void setPostDirectionIntersection(String postDirectionIntersection) {
        this.postDirectionIntersection = postDirectionIntersection;
    }

    public String getPOBox() {
        return this.POBox;
    }

    public void setPOBox(String pOBox) {
        this.POBox = pOBox;
    }

    public String getCivicNumberSuffix() {
        return this.civicNumberSuffix;
    }

    public void setCivicNumberSuffix(String civicNumberSuffix) {
        this.civicNumberSuffix = civicNumberSuffix;
    }

    public String getPOBoxInfo() {
        return this.POBoxInfo;
    }

    public void setPOBoxInfo(String boxInfo) {
        this.POBoxInfo = boxInfo;
    }

    public void setPreDirection(String preDirection) {
        this.preDirection = preDirection;
    }

    public void setPreDirectionIntersection(String preDirectionIntersection) {
        this.preDirectionIntersection = preDirectionIntersection;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getDistrict() {
        return this.district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getPostTown() {
        return this.postTown;
    }

    public void setPostTown(String postTown) {
        this.postTown = postTown;
    }

    public String getDependentLocality() {
        return this.dependentLocality;
    }

    public void setDependentLocality(String dependentLocality) {
        this.dependentLocality = dependentLocality;
    }

    public void setPOBoxAgency(String POBoxAgency) {
        this.POBoxAgency = POBoxAgency;
    }

    public String getPOBoxAgency() {
        return this.POBoxAgency;
    }

    public String getQuarter() {
        return this.quarter;
    }

    public void setQuarter(String quarter) {
        this.quarter = quarter;
    }

    public String getPostOfficeBox() {
        return this.PostOfficeBox;
    }

    public void setPostOfficeBox(String postOfficeBox) {
        this.PostOfficeBox = postOfficeBox;
    }

    public GeocodingLevels getGeocodingLevel() {
        this.geocodingLevel = this.calculateGeocodingLevel();
        return this.geocodingLevel;
    }

    private GeocodingLevels calculateGeocodingLevel() {
        if (this.houseNumber != null) {
            return GeocodingLevels.HOUSE_NUMBER;
        }
        if (this.streetName != null || this.streetType != null) {
            return GeocodingLevels.STREET;
        }
        if (this.city != null || this.dependentLocality != null || this.zipCode != null) {
            return GeocodingLevels.CITY;
        }
        if (this.state != null || this.district != null) {
            return GeocodingLevels.STATE;
        }
        if (this.country != null) {
            return GeocodingLevels.COUNTRY;
        }
        return GeocodingLevels.NONE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.POBox == null ? 0 : this.POBox.hashCode());
        result = 31 * result + (this.POBoxAgency == null ? 0 : this.POBoxAgency.hashCode());
        result = 31 * result + (this.POBoxInfo == null ? 0 : this.POBoxInfo.hashCode());
        result = 31 * result + (this.PostOfficeBox == null ? 0 : this.PostOfficeBox.hashCode());
        result = 31 * result + (this.StreetTypeIntersection == null ? 0 : this.StreetTypeIntersection.hashCode());
        result = 31 * result + (this.block == null ? 0 : this.block.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.civicNumberSuffix == null ? 0 : this.civicNumberSuffix.hashCode());
        result = 31 * result + (this.dependentLocality == null ? 0 : this.dependentLocality.hashCode());
        result = 31 * result + (this.district == null ? 0 : this.district.hashCode());
        result = 31 * result + (this.extraInfo == null ? 0 : this.extraInfo.hashCode());
        result = 31 * result + (this.floor == null ? 0 : this.floor.hashCode());
        result = 31 * result + (this.houseNumber == null ? 0 : this.houseNumber.hashCode());
        result = 31 * result + (this.houseNumberInfo == null ? 0 : this.houseNumberInfo.hashCode());
        result = 31 * result + (this.postDirection == null ? 0 : this.postDirection.hashCode());
        result = 31 * result + (this.postDirectionIntersection == null ? 0 : this.postDirectionIntersection.hashCode());
        result = 31 * result + (this.postTown == null ? 0 : this.postTown.hashCode());
        result = 31 * result + (this.preDirection == null ? 0 : this.preDirection.hashCode());
        result = 31 * result + (this.preDirectionIntersection == null ? 0 : this.preDirectionIntersection.hashCode());
        result = 31 * result + (this.quadrant == null ? 0 : this.quadrant.hashCode());
        result = 31 * result + (this.quarter == null ? 0 : this.quarter.hashCode());
        result = 31 * result + (this.recipientName == null ? 0 : this.recipientName.hashCode());
        result = 31 * result + (this.sector == null ? 0 : this.sector.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.streetName == null ? 0 : this.streetName.hashCode());
        result = 31 * result + (this.streetNameIntersection == null ? 0 : this.streetNameIntersection.hashCode());
        result = 31 * result + (this.streetType == null ? 0 : this.streetType.hashCode());
        result = 31 * result + (this.zipCode == null ? 0 : this.zipCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        if (this.POBox == null ? other.POBox != null : !this.POBox.equals(other.POBox)) {
            return false;
        }
        if (this.POBoxAgency == null ? other.POBoxAgency != null : !this.POBoxAgency.equals(other.POBoxAgency)) {
            return false;
        }
        if (this.POBoxInfo == null ? other.POBoxInfo != null : !this.POBoxInfo.equals(other.POBoxInfo)) {
            return false;
        }
        if (this.PostOfficeBox == null ? other.PostOfficeBox != null : !this.PostOfficeBox.equals(other.PostOfficeBox)) {
            return false;
        }
        if (this.StreetTypeIntersection == null ? other.StreetTypeIntersection != null : !this.StreetTypeIntersection.equals(other.StreetTypeIntersection)) {
            return false;
        }
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.civicNumberSuffix == null ? other.civicNumberSuffix != null : !this.civicNumberSuffix.equals(other.civicNumberSuffix)) {
            return false;
        }
        if (this.dependentLocality == null ? other.dependentLocality != null : !this.dependentLocality.equals(other.dependentLocality)) {
            return false;
        }
        if (this.district == null ? other.district != null : !this.district.equals(other.district)) {
            return false;
        }
        if (this.extraInfo == null ? other.extraInfo != null : !this.extraInfo.equals(other.extraInfo)) {
            return false;
        }
        if (this.floor == null ? other.floor != null : !this.floor.equals(other.floor)) {
            return false;
        }
        if (this.houseNumber == null ? other.houseNumber != null : !this.houseNumber.equals(other.houseNumber)) {
            return false;
        }
        if (this.houseNumberInfo == null ? other.houseNumberInfo != null : !this.houseNumberInfo.equals(other.houseNumberInfo)) {
            return false;
        }
        if (this.postDirection == null ? other.postDirection != null : !this.postDirection.equals(other.postDirection)) {
            return false;
        }
        if (this.postDirectionIntersection == null ? other.postDirectionIntersection != null : !this.postDirectionIntersection.equals(other.postDirectionIntersection)) {
            return false;
        }
        if (this.postTown == null ? other.postTown != null : !this.postTown.equals(other.postTown)) {
            return false;
        }
        if (this.preDirection == null ? other.preDirection != null : !this.preDirection.equals(other.preDirection)) {
            return false;
        }
        if (this.preDirectionIntersection == null ? other.preDirectionIntersection != null : !this.preDirectionIntersection.equals(other.preDirectionIntersection)) {
            return false;
        }
        if (this.quadrant == null ? other.quadrant != null : !this.quadrant.equals(other.quadrant)) {
            return false;
        }
        if (this.quarter == null ? other.quarter != null : !this.quarter.equals(other.quarter)) {
            return false;
        }
        if (this.recipientName == null ? other.recipientName != null : !this.recipientName.equals(other.recipientName)) {
            return false;
        }
        if (this.sector == null ? other.sector != null : !this.sector.equals(other.sector)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.streetName == null ? other.streetName != null : !this.streetName.equals(other.streetName)) {
            return false;
        }
        if (this.streetNameIntersection == null ? other.streetNameIntersection != null : !this.streetNameIntersection.equals(other.streetNameIntersection)) {
            return false;
        }
        if (this.streetType == null ? other.streetType != null : !this.streetType.equals(other.streetType)) {
            return false;
        }
        return !(this.zipCode == null ? other.zipCode != null : !this.zipCode.equals(other.zipCode));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Address [");
        if (this.lng != null) {
            builder.append("lng=");
            builder.append(this.lng);
            builder.append(", ");
        }
        if (this.lat != null) {
            builder.append("lat=");
            builder.append(this.lat);
            builder.append(", ");
        }
        if (this.geocodingLevel != null) {
            builder.append("geocodingLevel=");
            builder.append((Object)this.getGeocodingLevel());
            builder.append(", ");
        }
        if (this.recipientName != null) {
            builder.append("recipientName=");
            builder.append(this.recipientName);
            builder.append(", ");
        }
        if (this.houseNumber != null) {
            builder.append("houseNumber=");
            builder.append(this.houseNumber);
            builder.append(", ");
        }
        if (this.houseNumberInfo != null) {
            builder.append("houseNumberInfo=");
            builder.append(this.houseNumberInfo);
            builder.append(", ");
        }
        if (this.POBox != null) {
            builder.append("POBox=");
            builder.append(this.POBox);
            builder.append(", ");
        }
        if (this.POBoxInfo != null) {
            builder.append("POBoxInfo=");
            builder.append(this.POBoxInfo);
            builder.append(", ");
        }
        if (this.POBoxAgency != null) {
            builder.append("POBoxAgency=");
            builder.append(this.POBoxAgency);
            builder.append(", ");
        }
        if (this.civicNumberSuffix != null) {
            builder.append("civicNumberSuffix=");
            builder.append(this.civicNumberSuffix);
            builder.append(", ");
        }
        if (this.preDirection != null) {
            builder.append("preDirection=");
            builder.append(this.preDirection);
            builder.append(", ");
        }
        if (this.streetName != null) {
            builder.append("streetName=");
            builder.append(this.streetName);
            builder.append(", ");
        }
        if (this.streetType != null) {
            builder.append("streetType=");
            builder.append(this.streetType);
            builder.append(", ");
        }
        if (this.postDirection != null) {
            builder.append("postDirection=");
            builder.append(this.postDirection);
            builder.append(", ");
        }
        if (this.preDirectionIntersection != null) {
            builder.append("preDirectionIntersection=");
            builder.append(this.preDirectionIntersection);
            builder.append(", ");
        }
        if (this.streetNameIntersection != null) {
            builder.append("streetNameIntersection=");
            builder.append(this.streetNameIntersection);
            builder.append(", ");
        }
        if (this.StreetTypeIntersection != null) {
            builder.append("StreetTypeIntersection=");
            builder.append(this.StreetTypeIntersection);
            builder.append(", ");
        }
        if (this.postDirectionIntersection != null) {
            builder.append("postDirectionIntersection=");
            builder.append(this.postDirectionIntersection);
            builder.append(", ");
        }
        if (this.extraInfo != null) {
            builder.append("extraInfo=");
            builder.append(this.extraInfo);
            builder.append(", ");
        }
        if (this.floor != null) {
            builder.append("floor=");
            builder.append(this.floor);
            builder.append(", ");
        }
        if (this.quarter != null) {
            builder.append("quarter=");
            builder.append(this.quarter);
            builder.append(", ");
        }
        if (this.zipCode != null) {
            builder.append("zipCode=");
            builder.append(this.zipCode);
            builder.append(", ");
        }
        if (this.district != null) {
            builder.append("district=");
            builder.append(this.district);
            builder.append(", ");
        }
        if (this.dependentLocality != null) {
            builder.append("dependentLocality=");
            builder.append(this.dependentLocality);
            builder.append(", ");
        }
        if (this.city != null) {
            builder.append("city=");
            builder.append(this.city);
            builder.append(", ");
        }
        if (this.postTown != null) {
            builder.append("postTown=");
            builder.append(this.postTown);
            builder.append(", ");
        }
        if (this.state != null) {
            builder.append("state=");
            builder.append(this.state);
            builder.append(", ");
        }
        if (this.sector != null) {
            builder.append("sector=");
            builder.append(this.sector);
            builder.append(", ");
        }
        if (this.quadrant != null) {
            builder.append("quadrant=");
            builder.append(this.quadrant);
            builder.append(", ");
        }
        if (this.block != null) {
            builder.append("block=");
            builder.append(this.block);
            builder.append(", ");
        }
        if (this.PostOfficeBox != null) {
            builder.append("PostOfficeBox=");
            builder.append(this.PostOfficeBox);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

