/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.IOUtils;

final class FieldsWriter {
    static final byte FIELD_IS_TOKENIZED = 1;
    static final byte FIELD_IS_BINARY = 2;
    @Deprecated
    static final byte FIELD_IS_COMPRESSED = 4;
    static final int FORMAT = 0;
    static final int FORMAT_VERSION_UTF8_LENGTH_IN_BYTES = 1;
    static final int FORMAT_LUCENE_3_0_NO_COMPRESSED_FIELDS = 2;
    static final int FORMAT_CURRENT = 2;
    private FieldInfos fieldInfos;
    private Directory directory;
    private String segment;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsWriter(Directory directory, String segment, FieldInfos fn) throws IOException {
        this.directory = directory;
        this.segment = segment;
        this.fieldInfos = fn;
        boolean success = false;
        try {
            this.fieldsStream = directory.createOutput(IndexFileNames.segmentFileName(segment, "fdt"));
            this.indexStream = directory.createOutput(IndexFileNames.segmentFileName(segment, "fdx"));
            this.fieldsStream.writeInt(2);
            this.indexStream.writeInt(2);
            success = true;
            Object var6_5 = null;
            if (!success) {
                this.abort();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!success) {
                this.abort();
            }
            throw throwable;
        }
    }

    FieldsWriter(IndexOutput fdx, IndexOutput fdt, FieldInfos fn) {
        this.directory = null;
        this.segment = null;
        this.fieldInfos = fn;
        this.fieldsStream = fdt;
        this.indexStream = fdx;
    }

    void setFieldsStream(IndexOutput stream) {
        this.fieldsStream = stream;
    }

    void flushDocument(int numStoredFields, RAMOutputStream buffer) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(numStoredFields);
        buffer.writeTo(this.fieldsStream);
    }

    void skipDocument() throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (this.directory != null) {
            try {
                IOUtils.closeSafely(this.fieldsStream, this.indexStream);
                Object var2_1 = null;
                this.indexStream = null;
                this.fieldsStream = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.indexStream = null;
                this.fieldsStream = null;
                throw throwable;
            }
        }
    }

    void abort() {
        if (this.directory != null) {
            try {
                this.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                this.directory.deleteFile(IndexFileNames.segmentFileName(this.segment, "fdt"));
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                this.directory.deleteFile(IndexFileNames.segmentFileName(this.segment, "fdx"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    final void writeField(FieldInfo fi, Fieldable field) throws IOException {
        this.fieldsStream.writeVInt(fi.number);
        byte bits = 0;
        if (field.isTokenized()) {
            bits = (byte)(bits | 1);
        }
        if (field.isBinary()) {
            bits = (byte)(bits | 2);
        }
        this.fieldsStream.writeByte(bits);
        if (field.isBinary()) {
            byte[] data = field.getBinaryValue();
            int len = field.getBinaryLength();
            int offset = field.getBinaryOffset();
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, offset, len);
        } else {
            this.fieldsStream.writeString(field.stringValue());
        }
    }

    final void addRawDocuments(IndexInput stream, int[] lengths, int numDocs) throws IOException {
        long position;
        long start = position = this.fieldsStream.getFilePointer();
        for (int i = 0; i < numDocs; ++i) {
            this.indexStream.writeLong(position);
            position += (long)lengths[i];
        }
        this.fieldsStream.copyBytes(stream, position - start);
        assert (this.fieldsStream.getFilePointer() == position);
    }

    final void addDocument(Document doc) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        List<Fieldable> fields = doc.getFields();
        for (Fieldable field : fields) {
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        for (Fieldable field : fields) {
            if (!field.isStored()) continue;
            this.writeField(this.fieldInfos.fieldInfo(field.name()), field);
        }
    }
}

