/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.org.objectweb.asm.AnnotationVisitor;
import org.aspectj.org.objectweb.asm.Attribute;
import org.aspectj.org.objectweb.asm.ClassVisitor;
import org.aspectj.org.objectweb.asm.FieldVisitor;
import org.aspectj.org.objectweb.asm.MethodVisitor;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.asm.AjASMAttribute;
import org.aspectj.weaver.asm.AnnVisitor;
import org.aspectj.weaver.asm.AsmDelegate;
import org.aspectj.weaver.asm.AsmField;
import org.aspectj.weaver.asm.AsmMethod;
import org.aspectj.weaver.asm.FdVisitor;
import org.aspectj.weaver.asm.MethVisitor;

public class TypeVisitor
implements ClassVisitor {
    private final AsmDelegate relatedDelegate;
    private List methodsList = new ArrayList();
    private List fieldsList = new ArrayList();
    private List attributes = new ArrayList();
    protected List annotations = new ArrayList();
    private String name = null;
    private static final String AnnotationRetention = "Ljava/lang/annotation/Retention;";
    private static final String AnnotationTarget = "Ljava/lang/annotation/Target;";

    TypeVisitor(AsmDelegate delegate) {
        this.relatedDelegate = delegate;
    }

    public void visit(int version, int mods, String name, String signature, String superclassname, String[] interfacenames) {
        this.relatedDelegate.superclassName = superclassname;
        this.relatedDelegate.interfaceNames = interfacenames;
        this.relatedDelegate.classModifiers = mods;
        this.relatedDelegate.declaredSignature = signature;
        this.relatedDelegate.isGenericType = signature != null && signature.charAt(0) == '<';
        this.name = name;
    }

    public AnnotationVisitor visitAnnotation(String typeSignature, boolean vis) {
        AnnotationAJ annotation = new AnnotationAJ(typeSignature, vis);
        this.annotations.add(annotation);
        return new AnnVisitor(annotation);
    }

    public void visitAttribute(Attribute attr) {
        if (attr.type.equals("org.aspectj.weaver.WeaverVersion")) {
            AjAttribute.WeaverVersionInfo wv;
            this.relatedDelegate.weaverVersion = wv = (AjAttribute.WeaverVersionInfo)((AjASMAttribute)attr).unpack(this.relatedDelegate);
        } else {
            this.attributes.add(attr);
        }
    }

    public void visitInnerClass(String name, String outer, String inner, int access) {
        if (name.equals(this.name)) {
            this.relatedDelegate.isNested = true;
            this.relatedDelegate.isAnonymous = inner == null;
        }
    }

    public FieldVisitor visitField(int modifiers, String name, String descType, String signature, Object value) {
        AsmField rm = new AsmField(Member.FIELD, this.relatedDelegate.getResolvedTypeX(), modifiers, name, descType);
        rm.setGenericSignature(signature);
        rm.setClassDelegate(this.relatedDelegate);
        this.fieldsList.add(rm);
        if (AsmDelegate.careAboutMemberAnnotationsAndAttributes) {
            return new FdVisitor(rm);
        }
        return null;
    }

    public MethodVisitor visitMethod(int modifiers, String name, String desc, String signature, String[] exceptions) {
        if (Modifier.isInterface(this.relatedDelegate.getModifiers()) && Modifier.isAbstract(modifiers)) {
            modifiers |= 0x200;
        }
        AsmMethod rm = new AsmMethod(Member.METHOD, this.relatedDelegate.getResolvedTypeX(), modifiers, name, desc);
        rm.setGenericSignature(signature);
        rm.setClassDelegate(this.relatedDelegate);
        if (exceptions != null && exceptions.length != 0) {
            UnresolvedType[] excs = new UnresolvedType[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                excs[i] = UnresolvedType.forSignature("L" + exceptions[i] + ";");
            }
            rm.setCheckedExceptions(excs);
        }
        this.methodsList.add(rm);
        if (AsmDelegate.careAboutMemberAnnotationsAndAttributes) {
            return new MethVisitor(rm);
        }
        return null;
    }

    public void visitSource(String sourcefilename, String debug) {
        this.relatedDelegate.setSourcefilename(sourcefilename);
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitEnd() {
        this.relatedDelegate.methods = this.methodsList.toArray(new ResolvedMember[0]);
        this.methodsList.clear();
        this.relatedDelegate.fields = this.fieldsList.toArray(new ResolvedMember[0]);
        this.fieldsList.clear();
        if (this.attributes.size() > 0) {
            this.relatedDelegate.attributes = new ArrayList();
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Attribute element = (Attribute)iter.next();
                if (element instanceof AjASMAttribute && element.type.equals("org.aspectj.weaver.Aspect")) {
                    AjAttribute.Aspect aspectAttribute = (AjAttribute.Aspect)((AjASMAttribute)element).unpack(this.relatedDelegate);
                    this.relatedDelegate.perClause = aspectAttribute.reify(null);
                    this.relatedDelegate.isAspect = true;
                    continue;
                }
                this.relatedDelegate.attributes.add(element);
            }
        }
        boolean retentionPolicySet = false;
        if (this.annotations.size() > 0) {
            this.relatedDelegate.annotations = new ArrayList();
        }
        Iterator iter = this.annotations.iterator();
        while (iter.hasNext()) {
            AnnotationAJ element = (AnnotationAJ)iter.next();
            if (element.getTypeSignature().equals(AnnotationRetention)) {
                this.relatedDelegate.retentionPolicy = element.getStringValueOf("value");
                this.relatedDelegate.isRuntimeRetention = this.relatedDelegate.retentionPolicy.equals("RUNTIME");
                retentionPolicySet = true;
            }
            if (element.getTypeSignature().equals(AnnotationTarget)) {
                this.setDelegateFieldsForAnnotationTarget(element.getNameValuePairs());
            }
            this.relatedDelegate.annotations.add(element);
        }
        if (this.relatedDelegate.isAnnotation() && !retentionPolicySet) {
            this.relatedDelegate.retentionPolicy = "CLASS";
            this.relatedDelegate.isRuntimeRetention = false;
        }
    }

    private void setDelegateFieldsForAnnotationTarget(List nvpairs) {
        if (nvpairs.size() > 0) {
            boolean canTargetType = false;
            ArrayAnnotationValue targetsArray = (ArrayAnnotationValue)((AnnotationNameValuePair)nvpairs.get(0)).getValue();
            AnnotationValue[] targets = targetsArray.getValues();
            ArrayList<AnnotationTargetKind> targetKinds = new ArrayList<AnnotationTargetKind>();
            for (int i = 0; i < targets.length; ++i) {
                String targetKind = targets[i].stringify();
                if (targetKind.equals("ANNOTATION_TYPE")) {
                    targetKinds.add(AnnotationTargetKind.ANNOTATION_TYPE);
                    continue;
                }
                if (targetKind.equals("CONSTRUCTOR")) {
                    targetKinds.add(AnnotationTargetKind.CONSTRUCTOR);
                    continue;
                }
                if (targetKind.equals("FIELD")) {
                    targetKinds.add(AnnotationTargetKind.FIELD);
                    continue;
                }
                if (targetKind.equals("LOCAL_VARIABLE")) {
                    targetKinds.add(AnnotationTargetKind.LOCAL_VARIABLE);
                    continue;
                }
                if (targetKind.equals("METHOD")) {
                    targetKinds.add(AnnotationTargetKind.METHOD);
                    continue;
                }
                if (targetKind.equals("PACKAGE")) {
                    targetKinds.add(AnnotationTargetKind.PACKAGE);
                    continue;
                }
                if (targetKind.equals("PARAMETER")) {
                    targetKinds.add(AnnotationTargetKind.PARAMETER);
                    continue;
                }
                if (!targetKind.equals("TYPE")) continue;
                targetKinds.add(AnnotationTargetKind.TYPE);
                canTargetType = true;
            }
            this.relatedDelegate.targetKinds = targetKinds.toArray(new AnnotationTargetKind[0]);
            this.relatedDelegate.canAnnotationTargetType = canTargetType;
        }
    }
}

