/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernatespatial.HibernateSpatialException;
import org.hibernatespatial.SpatialDialect;
import org.hibernatespatial.helper.PropertyFileReader;
import org.hibernatespatial.spi.SpatialDialectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBSpatialExtension {
    protected static Set<SpatialDialectProvider> providers = new HashSet<SpatialDialectProvider>();
    private static final Log log = LogFactory.getLog(HBSpatialExtension.class);
    private static SpatialDialect defaultSpatialDialect = null;
    private static final String DIALECT_PROP_NAME = "hibernate.spatial.dialect";

    static {
        log.info((Object)"Initializing HBSpatialExtension");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = null;
        try {
            resources = loader.getResources("META-INF/services/" + SpatialDialectProvider.class.getName());
            HashSet<String> names = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    names.addAll(HBSpatialExtension.providerNamesFromReader(is));
                }
                finally {
                    is.close();
                }
            }
            for (String s : names) {
                try {
                    log.info((Object)("Attempting to load Hibernate Spatial Provider " + s));
                    SpatialDialectProvider provider = (SpatialDialectProvider)loader.loadClass(s).newInstance();
                    if (defaultSpatialDialect == null) {
                        HBSpatialExtension.setDefaultSpatialDialect(provider.getDefaultDialect());
                    }
                    providers.add(provider);
                }
                catch (Exception e) {
                    throw new HibernateSpatialException("Problem loading provider class", e);
                }
            }
        }
        catch (IOException e) {
            throw new HibernateSpatialException("No " + SpatialDialectProvider.class.getName() + " found in META-INF/services", e);
        }
        String dialectProp = System.getProperty(DIALECT_PROP_NAME);
        if (dialectProp != null) {
            log.info((Object)("Spatial Dialect configured as system property: " + dialectProp));
            boolean found = false;
            block9: for (SpatialDialectProvider provider : providers) {
                String[] stringArray = provider.getSupportedDialects();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String dialect = stringArray[n];
                    if (dialect.equals(dialectProp)) {
                        defaultSpatialDialect = provider.createSpatialDialect(dialectProp, null);
                        found = true;
                        break block9;
                    }
                    ++n;
                }
            }
            if (!found) {
                log.warn((Object)("Spatial dialect " + dialectProp + " configured as sytem property, but dialect not found"));
            }
        }
        if (defaultSpatialDialect == null) {
            log.warn((Object)"Hibernate Spatial Configured but no spatial dialect");
        } else {
            log.info((Object)("Hibernate Spatial configured. Using dialect: " + defaultSpatialDialect.getClass().getCanonicalName()));
        }
    }

    private HBSpatialExtension() {
    }

    public static void setDefaultSpatialDialect(SpatialDialect dialect) {
        defaultSpatialDialect = dialect;
    }

    public static SpatialDialect getDefaultSpatialDialect() {
        return defaultSpatialDialect;
    }

    public static SpatialDialect createSpatialDialect(String dialectName, Map properties) {
        SpatialDialect dialect = null;
        for (SpatialDialectProvider provider : providers) {
            dialect = provider.createSpatialDialect(dialectName, properties);
            if (dialect != null) break;
        }
        if (dialect == null) {
            throw new HibernateSpatialException("No SpatialDialect provider for persistenceUnit " + dialectName);
        }
        return dialect;
    }

    private static Set<String> providerNamesFromReader(InputStream is) throws IOException {
        PropertyFileReader reader = new PropertyFileReader(is);
        return reader.getNonCommentLines();
    }
}

