/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer.xml;

import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.Helper;
import com.gisgraphy.serializer.common.SerializerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbXmlSerializer
extends AbstractSerializer {
    private static final Logger logger = Logger.getLogger(JaxbXmlSerializer.class);

    public <T> T read(InputStream inputStream, Class<T> classToBeBound) throws SerializerException {
        JAXBContext context = null;
        Unmarshaller unMarshaller = null;
        try {
            if (classToBeBound == String.class) {
                return (T)Helper.inputStreamToString((InputStream)inputStream);
            }
            context = JAXBContext.newInstance((Class[])new Class[]{classToBeBound});
            unMarshaller = context.createUnmarshaller();
            JAXBElement objectUnmarshal = unMarshaller.unmarshal((Source)new StreamSource(inputStream), classToBeBound);
            return (T)(objectUnmarshal != null ? objectUnmarshal.getValue() : null);
        }
        catch (JAXBException e) {
            throw new SerializerException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SerializerException((Exception)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)"Invalid XML document", (Throwable)e);
            return null;
        }
    }

    public void write(OutputStream outputStream, Object object, boolean indent, Map<String, Object> extraParams) throws SerializerException {
        if (object == null) {
            throw new SerializerException("can not serialize null object in XML");
        }
        JAXBContext context = null;
        Marshaller marshaller = null;
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)indent);
            marshaller.marshal(object, outputStream);
        }
        catch (JAXBException e) {
            throw new SerializerException((Exception)((Object)e));
        }
    }
}

