/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.serializer.json;

import com.gisgraphy.serializer.common.AbstractSerializer;
import com.gisgraphy.serializer.common.Helper;
import com.gisgraphy.serializer.common.SerializerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSerializer
extends AbstractSerializer {
    private static Pattern p = Pattern.compile("\\w+");
    private static final Logger logger = Logger.getLogger(JsonSerializer.class);
    private ObjectMapper mapper = new ObjectMapper();

    public JsonSerializer() {
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().set((MapperConfig.ConfigFeature)SerializationConfig.Feature.INDENT_OUTPUT, this.isDefault_indentation());
        this.mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.mapper.getJsonFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public <T> T read(InputStream inputStream, Class<T> classToBeBound) throws SerializerException {
        Object objectUnmarshal;
        try {
            if (classToBeBound == String.class) {
                return (T)Helper.inputStreamToString((InputStream)inputStream);
            }
            if (classToBeBound.isAssignableFrom(HashMap.class)) {
                objectUnmarshal = this.mapper.readValue(inputStream, new TypeReference<T>(){});
                System.out.println(objectUnmarshal.getClass());
            } else {
                objectUnmarshal = this.mapper.readValue(inputStream, classToBeBound);
            }
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
        return (T)objectUnmarshal;
    }

    public void write(OutputStream outputStream, Object object, boolean indent, Map<String, Object> extraParams) throws SerializerException {
        Object callbackMethodName = null;
        if (extraParams != null) {
            callbackMethodName = extraParams.get("callbackMethodName");
        }
        try {
            boolean isValidMethodName;
            boolean bl = isValidMethodName = callbackMethodName != null && callbackMethodName instanceof String && p.matcher((String)callbackMethodName).matches();
            if (isValidMethodName) {
                outputStream.write(new String(callbackMethodName + "(").getBytes("UTF-8"));
            }
            this.mapper.writeValue(outputStream, object);
            if (isValidMethodName) {
                outputStream.write(new String(");").getBytes("UTF-8"));
            }
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyJsonMapDeserializer
    extends StdDeserializer<Integer> {
        protected EmptyJsonMapDeserializer(Class<?> vc) {
            super(vc);
        }

        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return super._parseIntPrimitive(jp, ctxt);
        }
    }
}

