/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.i18n;

import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class MultiViewsTool
implements ViewTool {
    protected static final String DEFAULT_LANGUAGE_KEY = "org.apache.velocity.tools.view.i18n.defaultLanguage";
    protected String defaultLanguage;

    public void init(Object obj) {
        if (!(obj instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext context = (ViewContext)obj;
        Context vc = context.getVelocityContext();
        this.defaultLanguage = (String)vc.get(DEFAULT_LANGUAGE_KEY);
        if (this.defaultLanguage == null || this.defaultLanguage.trim().equals("")) {
            ServletContext sc = context.getServletContext();
            this.defaultLanguage = (String)sc.getAttribute(DEFAULT_LANGUAGE_KEY);
            if (this.defaultLanguage == null || this.defaultLanguage.trim().equals("")) {
                this.defaultLanguage = Locale.getDefault().getLanguage();
            }
        }
    }

    public String findLocalizedResource(String name, Locale locale) {
        return this.findLocalizedResource(name, locale.getLanguage());
    }

    public String findLocalizedResource(String name) {
        return this.findLocalizedResource(this.defaultLanguage);
    }

    public String findLocalizedResource(String name, String language) {
        String localizedName = name + '.' + language;
        if (!Velocity.templateExists((String)localizedName)) {
            String defaultLangSuffix = '.' + this.defaultLanguage;
            if (localizedName.endsWith(defaultLangSuffix)) {
                localizedName = name;
            } else {
                localizedName = name + defaultLangSuffix;
                if (!Velocity.templateExists((String)localizedName)) {
                    localizedName = name;
                }
            }
        }
        return localizedName;
    }
}

