/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Logging;
import org.opengis.util.InternationalString;

public class GrowableInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 5760033376627376937L;
    private static final Map LOCALES = new HashMap();
    private Map localMap;
    private transient Set localSet;

    public GrowableInternationalString() {
        this.localMap = Collections.EMPTY_MAP;
    }

    public GrowableInternationalString(String string) {
        this.localMap = string != null ? Collections.singletonMap(null, string) : Collections.EMPTY_MAP;
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        if (string != null) {
            switch (this.localMap.size()) {
                case 0: {
                    this.localMap = Collections.singletonMap(locale, string);
                    this.defaultValue = null;
                    return;
                }
                case 1: {
                    this.localMap = new HashMap(this.localMap);
                }
            }
            String old = (String)this.localMap.get(locale);
            if (old != null) {
                if (string.equals(old)) {
                    return;
                }
                throw new IllegalArgumentException();
            }
            this.localMap.put(locale, string);
            this.defaultValue = null;
        }
    }

    public boolean add(String prefix, String key, String string) throws IllegalArgumentException {
        if (!key.startsWith(prefix)) {
            return false;
        }
        int position = prefix.length();
        int length = key.length();
        String[] parts = new String[]{"", "", ""};
        int i = 0;
        while (true) {
            int next;
            if (position == length) {
                Locale locale = i == 0 ? (Locale)null : GrowableInternationalString.unique(new Locale(parts[0], parts[1], parts[2]));
                this.add(locale, string);
                return true;
            }
            if (key.charAt(position) != '_' || i == parts.length) break;
            if ((next = key.indexOf(95, ++position)) < 0) {
                next = length;
            } else if (next == position) break;
            int n = position;
            position = next;
            parts[i] = key.substring(n, position);
            ++i;
        }
        throw new IllegalArgumentException(Errors.format(42, "locale", key.substring(prefix.length())));
    }

    private static synchronized Locale unique(Locale locale) {
        Locale candidate;
        if (LOCALES.isEmpty()) {
            try {
                Field[] fields = Locale.class.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!Modifier.isStatic(field.getModifiers()) || !Locale.class.isAssignableFrom(field.getType())) continue;
                    Locale toAdd = (Locale)field.get(null);
                    LOCALES.put(toAdd, toAdd);
                }
            }
            catch (Exception exception) {
                Logging.unexpectedException("org.geotools.util", GrowableInternationalString.class, "unique", (Throwable)exception);
            }
        }
        if ((candidate = (Locale)LOCALES.get(locale)) != null) {
            return candidate;
        }
        LOCALES.put(locale, locale);
        return locale;
    }

    public Set getLocales() {
        if (this.localSet == null) {
            this.localSet = Collections.unmodifiableSet(this.localMap.entrySet());
        }
        return this.localSet;
    }

    public String toString(Locale locale) {
        Iterator it;
        String text;
        while (locale != null) {
            text = (String)this.localMap.get(locale);
            if (text != null) {
                return text;
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (variant.length() != 0) {
                locale = new Locale(language, country);
                continue;
            }
            if (country.length() == 0) break;
            locale = new Locale(language);
        }
        if ((text = (String)this.localMap.get(null)) == null && (it = this.localMap.values().iterator()).hasNext()) {
            return (String)it.next();
        }
        return text;
    }

    public boolean isSubsetOf(Object candidate) {
        if (candidate instanceof InternationalString) {
            InternationalString string = (InternationalString)candidate;
            for (Map.Entry entry : this.localMap.entrySet()) {
                Locale locale = (Locale)entry.getKey();
                String text = (String)entry.getValue();
                if (text.equals(string.toString(locale))) continue;
                return false;
            }
        } else if (candidate instanceof CharSequence) {
            String string = candidate.toString();
            for (String text : this.localMap.values()) {
                if (text.equals(string)) continue;
                return false;
            }
        } else {
            if (candidate instanceof Map) {
                return ((Map)candidate).entrySet().containsAll(this.localMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GrowableInternationalString that = (GrowableInternationalString)object;
            return Utilities.equals(this.localMap, that.localMap);
        }
        return false;
    }

    public int hashCode() {
        return 0x8C44C329 ^ ((Object)this.localMap).hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = this.localMap.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] entries = this.localMap.entrySet().toArray(new Map.Entry[size]);
        if (size == 1) {
            Map.Entry entry = entries[0];
            this.localMap = Collections.singletonMap(GrowableInternationalString.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localMap.clear();
            for (int i = 0; i < entries.length; ++i) {
                Map.Entry entry = entries[i];
                this.localMap.put(GrowableInternationalString.unique((Locale)entry.getKey()), entry.getValue());
            }
        }
    }
}

