/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedCollection;
import org.opengis.util.Cloneable;

public class CheckedArrayList
extends ArrayList
implements CheckedCollection,
Cloneable {
    private static final long serialVersionUID = -587331971085094268L;
    private final Class type;

    public CheckedArrayList(Class type) {
        this.type = type;
        this.ensureNonNull();
    }

    public CheckedArrayList(Class type, int capacity) {
        super(capacity);
        this.type = type;
        this.ensureNonNull();
    }

    public Class getElementType() {
        return this.type;
    }

    private void ensureNonNull() {
        if (this.type == null) {
            throw new IllegalArgumentException(Errors.format(105, "type"));
        }
    }

    protected void ensureValidType(Object element) throws IllegalArgumentException {
        if (element != null && !this.type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format(45, Utilities.getShortClassName(element), Utilities.getShortName(this.type)));
        }
    }

    private void ensureValid(Collection collection) throws IllegalArgumentException {
        if (collection != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                this.ensureValidType(it.next());
            }
        }
    }

    public Object set(int index, Object element) {
        this.ensureValidType(element);
        return super.set(index, element);
    }

    public boolean add(Object element) {
        this.ensureValidType(element);
        return super.add(element);
    }

    public void add(int index, Object element) {
        this.ensureValidType(element);
        super.add(index, element);
    }

    public boolean addAll(Collection collection) {
        this.ensureValid(collection);
        return super.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        this.ensureValid(collection);
        return super.addAll(index, collection);
    }
}

