/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.lineage;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.util.InternationalString;

public class ProcessStepImpl
extends MetadataEntity
implements ProcessStep {
    private static final long serialVersionUID = 4629429337326490722L;
    private InternationalString description;
    private InternationalString rationale;
    private long date;
    private Collection processors;
    private Collection sources;

    public ProcessStepImpl() {
    }

    public ProcessStepImpl(ProcessStep source) {
        super(source);
    }

    public ProcessStepImpl(InternationalString description) {
        this.setDescription(description);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public InternationalString getRationale() {
        return this.rationale;
    }

    public synchronized void setRationale(InternationalString newValue) {
        this.checkWritePermission();
        this.rationale = newValue;
    }

    public synchronized Date getDate() {
        return this.date != Long.MIN_VALUE ? new Date(this.date) : null;
    }

    public synchronized void setDate(Date newValue) {
        this.checkWritePermission();
        this.date = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized Collection getProcessors() {
        this.processors = this.nonNullCollection(this.processors, ResponsibleParty.class);
        return this.processors;
    }

    public synchronized void setProcessors(Collection newValues) {
        this.processors = this.copyCollection(newValues, this.processors, ResponsibleParty.class);
    }

    public synchronized Collection getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public synchronized void setSources(Collection newValues) {
        this.sources = this.copyCollection(newValues, this.sources, Source.class);
    }
}

