/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.metadata.AbstractMetadata;
import org.geotools.metadata.MetadataStandard;
import org.geotools.metadata.UnmodifiableMetadataException;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.CheckedHashSet;
import org.geotools.util.Logging;

public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object source) throws ClassCastException, UnmodifiableMetadataException {
        super(source);
    }

    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata candidate;
            try {
                candidate = (ModifiableMetadata)this.clone();
            }
            catch (CloneNotSupportedException exception) {
                Logging.unexpectedException(LOGGER, exception);
                return this;
            }
            candidate.freeze();
            this.unmodifiable = candidate;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    /*
     * WARNING - void declaration
     */
    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            void var3_6;
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return collection instanceof List ? Collections.EMPTY_LIST : Collections.EMPTY_SET;
            }
            Object[] array = collection.toArray();
            boolean bl = false;
            while (var3_6 < array.length) {
                array[var3_6] = ModifiableMetadata.unmodifiable(array[var3_6]);
                ++var3_6;
            }
            List<Object> list = Arrays.asList(array);
            if (collection instanceof Set) {
                return Collections.unmodifiableSet(new LinkedHashSet<Object>(list));
            }
            return Collections.unmodifiableList(list);
        }
        if (object instanceof Map) {
            LinkedHashMap map = (LinkedHashMap)object;
            if (map.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            map = new LinkedHashMap(map);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return Collections.unmodifiableMap(map);
        }
        if (object instanceof org.opengis.util.Cloneable) {
            return ((org.opengis.util.Cloneable)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeze() {
        ModifiableMetadata success = null;
        try {
            this.unmodifiable = FREEZING;
            this.getStandard().freeze(this);
            success = this;
        }
        finally {
            this.unmodifiable = success;
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        assert (Thread.holdsLock(this));
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format(200));
        }
        this.invalidate();
    }

    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final Collection copyCollection(Collection source, Collection target, Class elementType) throws UnmodifiableMetadataException {
        if (this.unmodifiable == FREEZING) {
            assert (!ModifiableMetadata.isModifiable(source));
            return source;
        }
        this.checkWritePermission();
        if (source == null) {
            if (target != null) {
                target.clear();
            }
        } else {
            boolean isList = source instanceof List;
            if (target != null && target instanceof List == isList) {
                target.clear();
            } else {
                int capacity = source.size();
                if (isList) {
                    target = new CheckedArrayList(elementType, capacity);
                } else {
                    capacity = Math.round((float)capacity / 0.75f) + 1;
                    target = new CheckedHashSet(elementType, capacity);
                }
            }
            target.addAll(source);
        }
        return target;
    }

    protected final Collection nonNullCollection(Collection c, Class elementType) {
        assert (Thread.holdsLock(this));
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new CheckedHashSet(elementType);
        }
        return Collections.EMPTY_SET;
    }

    protected final List nonNullList(List c, Class elementType) {
        assert (Thread.holdsLock(this));
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new CheckedArrayList(elementType);
        }
        return Collections.EMPTY_LIST;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        public MetadataStandard getStandard() {
            return null;
        }
    }
}

