/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.geotools.factory.Factories;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.Hints;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Logging;
import org.geotools.util.Version;

public final class GeoTools {
    private static final Version VERSION = new Version("2.5.M1");
    private static final EventListenerList LISTENERS = new EventListenerList();
    private static final Map BINDINGS = new HashMap();
    public static final String CRS_AUTHORITY_EXTRA_DIRECTORY = "org.geotools.referencing.crs-directory";
    public static final String EPSG_DATA_SOURCE = "org.geotools.referencing.epsg-datasource";
    public static final String FORCE_LONGITUDE_FIRST_AXIS_ORDER = "org.geotools.referencing.forceXY";
    static InitialContext context;

    private GeoTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bind(String property, RenderingHints.Key key) {
        Map map = BINDINGS;
        synchronized (map) {
            RenderingHints.Key old = BINDINGS.put(property, key);
            if (old == null) {
                return;
            }
            BINDINGS.put(property, old);
        }
        throw new IllegalArgumentException(Errors.format(42, "property", property));
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static void init(Hints hints) {
        if (!Logging.isCommonsLoggingAvailable() || !Logging.GEOTOOLS.redirectToCommonsLogging()) {
            Logging.GEOTOOLS.forceMonolineConsoleOutput();
        }
        Hints.putSystemDefault(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanForSystemHints(Hints hints) {
        assert (Thread.holdsLock(hints));
        boolean changed = false;
        Map map = BINDINGS;
        synchronized (map) {
            for (Map.Entry entry : BINDINGS.entrySet()) {
                Object old;
                String property;
                String propertyKey = (String)entry.getKey();
                try {
                    property = System.getProperty(propertyKey);
                }
                catch (SecurityException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (property == null) continue;
                Object value = property;
                RenderingHints.Key hintKey = (RenderingHints.Key)entry.getValue();
                if (hintKey.getClass().equals(Hints.Key.class)) {
                    Class type = ((Hints.Key)hintKey).getValueClass();
                    if (type.equals(Boolean.class)) {
                        value = Boolean.valueOf(property);
                    } else if (Number.class.isAssignableFrom(type)) {
                        try {
                            value = XMath.valueOf(type, property);
                        }
                        catch (NumberFormatException e) {
                            GeoTools.unexpectedException(e);
                            continue;
                        }
                    }
                }
                try {
                    old = hints.put(hintKey, value);
                }
                catch (IllegalArgumentException e) {
                    GeoTools.unexpectedException(e);
                    continue;
                }
                if (changed || Utilities.equals(old, value)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException("org.geotools.factory", Hints.class, "scanSystemProperties", (Throwable)exception);
    }

    public static Hints getDefaultHints() {
        return Hints.getDefaults();
    }

    public static void addFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories.addFactoryIteratorProvider(provider);
    }

    public static void removeFactoryIteratorProvider(FactoryIteratorProvider provider) {
        Factories.removeFactoryIteratorProvider(provider);
    }

    public static void addChangeListener(ChangeListener listener) {
        GeoTools.removeChangeListener(listener);
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    public static void fireConfigurationChanged() {
        ChangeEvent event = new ChangeEvent(GeoTools.class);
        Object[] listeners = LISTENERS.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        arguments.out.print("GeoTools version ");
        arguments.out.println(GeoTools.getVersion());
    }

    public static void init(InitialContext applicationContext) {
        context = applicationContext;
    }

    public static synchronized InitialContext getInitialContext(Hints hints) throws NamingException {
        if (context == null) {
            context = new InitialContext();
        }
        return context;
    }

    public static String fixName(String name) {
        try {
            return GeoTools.fixName(GeoTools.getInitialContext(null), name);
        }
        catch (NamingException e) {
            return name;
        }
    }

    public static String fixName(InitialContext context, String name) {
        try {
            if (context == null || name == null) {
                return name;
            }
            if (name.indexOf(58) != -1) {
                String fixed = null;
                for (String part : name.split(":")) {
                    fixed = fixed == null ? part : context.composeName(fixed, part);
                }
                return fixed;
            }
            if (name.indexOf(47) != -1) {
                String fixed = null;
                for (String part : name.split("/")) {
                    fixed = fixed == null ? part : context.composeName(fixed, part);
                }
                return fixed;
            }
            return name;
        }
        catch (NamingException e) {
            return name;
        }
    }

    static {
        GeoTools.bind(CRS_AUTHORITY_EXTRA_DIRECTORY, Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        GeoTools.bind(EPSG_DATA_SOURCE, Hints.EPSG_DATA_SOURCE);
        GeoTools.bind(FORCE_LONGITUDE_FIRST_AXIS_ORDER, Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }
}

