/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.servlet;

import com.gisgraphy.addressparser.AddressParserException;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.addressparser.exception.AddressParserErrorVisitor;
import com.gisgraphy.addressparser.web.AddressQueryHttpBuilder;
import com.gisgraphy.domain.valueobject.GisgraphyServiceType;
import com.gisgraphy.helper.HTMLHelper;
import com.gisgraphy.serializer.common.IoutputFormatVisitor;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.servlet.GisgraphyServlet;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractAddressServlet
extends GisgraphyServlet {
    protected static Logger logger = Logger.getLogger(AbstractAddressServlet.class);
    public static final String ADDRESS_PARAMETER = "address";
    public static final String COUNTRY_PARAMETER = "country";
    public static final String OUTPUT_FORMAT_PARAMETER = "format";
    public static final String CALLBACK_PARAMETER = "callback";
    public static final String INDENT_PARAMETER = "indent";
    public static final String POSTAL_PARAMETER = "postal";
    public static final int QUERY_MAX_LENGTH = 400;
    private static final long serialVersionUID = 7804855543117309510L;

    protected AddressQueryHttpBuilder getAddressQueryHttpBuilder() {
        return AddressQueryHttpBuilder.getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws AddressParserException, IOException {
        OutputFormat format = OutputFormat.getDefault();
        try {
            format = this.setResponseContentType(req, resp);
            if (HTMLHelper.isParametersEmpty(req, ADDRESS_PARAMETER, COUNTRY_PARAMETER)) {
                this.sendCustomError(ResourceBundle.getBundle("ApplicationResources").getString("error.addressparser.requiredparameters"), format, resp, req);
                return;
            }
            AddressQuery query = this.getAddressQueryHttpBuilder().buildFromRequest(req);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query=" + query));
            }
            String UA = req.getHeader("User-Agent");
            String referer = req.getHeader("Referer");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("A " + this.getGisgraphyServiceType() + " request from " + req.getRemoteHost() + " / " + req.getRemoteAddr() + " was received , Referer : " + referer + " , UA : " + UA));
            }
            this.processRequest(query, resp);
        }
        catch (AddressParserException e) {
            logger.error((Object)("error while execute an address query from http request : " + (Object)((Object)e)));
            String errorMessage = this.isDebugMode() ? " : " + e.getMessage() : "";
            this.sendCustomError(ResourceBundle.getBundle("ApplicationResources").getString("error.error") + errorMessage, format, resp, req);
        }
        catch (RuntimeException e) {
            logger.error((Object)("error while execute a Parser query from http request : " + e));
            String errorMessage = this.isDebugMode() ? " : " + e.getMessage() : "";
            this.sendCustomError(ResourceBundle.getBundle("ApplicationResources").getString("error.error") + errorMessage, format, resp, req);
        }
    }

    public abstract void processRequest(AddressQuery var1, HttpServletResponse var2) throws IOException;

    public IoutputFormatVisitor getErrorVisitor(String errorMessage) {
        return new AddressParserErrorVisitor(errorMessage);
    }

    public abstract GisgraphyServiceType getGisgraphyServiceType();
}

