/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.rest;

import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClientException;
import com.gisgraphy.serializer.UniversalSerializer;
import com.gisgraphy.serializer.common.OutputFormat;
import com.gisgraphy.serializer.common.SerializerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient
implements IRestClient {
    private HttpClient httpClient;
    private static Logger logger = LoggerFactory.getLogger(RestClient.class);

    public RestClient() {
        this(new MultiThreadedHttpConnectionManager());
    }

    public RestClient(MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager) throws RestClientException {
        if (multiThreadedHttpConnectionManager == null) {
            throw new RestClientException("multiThreadedHttpConnectionManager can not be null");
        }
        this.httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setHttpElementCharset("utf8");
        httpClientParams.setConnectionManagerTimeout(15000L);
        httpClientParams.setParameter("http.useragent", (Object)"gisgraphy/java-client-3.0");
        this.httpClient.setParams(httpClientParams);
        if (this.httpClient == null) {
            throw new RestClientException("Can not instanciate http client with multiThreadedHttpConnectionManager : " + multiThreadedHttpConnectionManager);
        }
    }

    @Override
    public <T> T get(String url, Class<T> classToBeBound, OutputFormat format) throws RestClientException {
        if (url == null) {
            throw new RestClientException("Can not call a null url");
        }
        GetMethod getMethod = null;
        try {
            Object obj;
            if (classToBeBound == null) {
                throw new RestClientException("Can not bound a null class");
            }
            logger.info("will call url : " + url);
            getMethod = new GetMethod(url);
            InputStream inputStream = this.executeMethod((HttpMethod)getMethod);
            Object object = obj = UniversalSerializer.getInstance().read(inputStream, classToBeBound, format);
            return (T)object;
        }
        catch (SerializerException e) {
            throw new RestClientException("an error occured during de-serialization of the http stream " + e.getMessage(), e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    @Override
    public void get(String url, OutputStream outputStream, OutputFormat format) throws RestClientException {
        if (url == null) {
            throw new RestClientException("Can not call a null url");
        }
        GetMethod getMethod = null;
        try {
            int numRead;
            if (outputStream == null) {
                throw new RestClientException("Can not serialize in a null outputStream");
            }
            logger.info("will call url : " + url);
            getMethod = new GetMethod(url);
            InputStream inputStream = this.executeMethod((HttpMethod)getMethod);
            byte[] buf = new byte[256];
            while ((numRead = inputStream.read(buf)) >= 0) {
                outputStream.write(buf, 0, numRead);
            }
        }
        catch (IOException e) {
            throw new RestClientException("An error occured during writing of the stream" + e.getMessage(), e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {}
        }
    }

    private InputStream executeMethod(HttpMethod httpMethod) throws RestClientException {
        int statusCode = -1;
        try {
            statusCode = this.executeAndCheckStatusCode(httpMethod);
            logger.info("URL " + httpMethod.getURI() + " returns http status :" + statusCode);
            return httpMethod.getResponseBodyAsStream();
        }
        catch (HttpException e) {
            throw new RestClientException(statusCode, e.getMessage());
        }
        catch (IOException e) {
            throw new RestClientException(statusCode, e.getMessage());
        }
    }

    private int executeAndCheckStatusCode(HttpMethod httpMethod) throws IOException, HttpException, RestClientException {
        int statusCode = this.httpClient.executeMethod(httpMethod);
        if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
            throw new RestClientException(statusCode, "restclient exception for " + httpMethod.getURI() + " : " + statusCode + ", " + HttpStatus.getStatusText((int)statusCode));
        }
        return statusCode;
    }

    private HttpMethod createPostMethod(String url, Map<String, Object> map) throws RestClientException {
        PostMethod httpMethod = new PostMethod(url);
        if (map != null) {
            for (String key : map.keySet()) {
                if (map.get(key) == null) continue;
                httpMethod.addParameter(key, map.get(key).toString());
            }
        }
        httpMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        return httpMethod;
    }

    private HttpMethod createPutMethod(String url, Map<String, Object> map) throws RestClientException {
        PutMethod httpMethod = new PutMethod(url);
        StringBuilder responseBody = new StringBuilder();
        if (map != null) {
            for (String key : map.keySet()) {
                if (map.get(key) == null) continue;
                responseBody.append(String.format("%s=%s\n", key, map.get(key).toString()));
            }
        }
        String responseBodyAsString = responseBody.toString();
        httpMethod.setRequestEntity((RequestEntity)new StringRequestEntity(responseBodyAsString.substring(0, responseBody.length())));
        httpMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        return httpMethod;
    }
}

