/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.rest;

import com.gisgraphy.rest.RestClientException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanToRestParameter {
    public static String toQueryString(Object object) {
        if (object == null) {
            throw new RestClientException("Can not get queryString for null object");
        }
        StringBuilder sb = new StringBuilder(128);
        try {
            boolean first = true;
            String andValue = "&";
            for (PropertyDescriptor thisPropertyDescriptor : Introspector.getBeanInfo(object.getClass(), Object.class).getPropertyDescriptors()) {
                Object property = PropertyUtils.getProperty((Object)object, (String)thisPropertyDescriptor.getName());
                if (property == null) continue;
                sb.append(first ? "?" : andValue);
                sb.append(thisPropertyDescriptor.getName());
                sb.append("=");
                sb.append(URLEncoder.encode(property.toString(), "UTF-8"));
                first = false;
            }
        }
        catch (Exception e) {
            throw new RestClientException("can not generate url for bean: " + e.getMessage(), e);
        }
        return sb.toString();
    }

    public static Map<String, String> ToMap(Object object) {
        if (object == null) {
            throw new RestClientException("Can not get queryString for null object");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (PropertyDescriptor thisPropertyDescriptor : Introspector.getBeanInfo(object.getClass(), Object.class).getPropertyDescriptors()) {
                Object property = PropertyUtils.getProperty((Object)object, (String)thisPropertyDescriptor.getName());
                if (property == null) continue;
                result.put(thisPropertyDescriptor.getName(), property.toString());
            }
        }
        catch (Exception e) {
            throw new RestClientException("can not generate Map for bean : " + e.getMessage(), e);
        }
        return result;
    }
}

