/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.helper;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class BeanHelper {
    private static final long serialVersionUID = 2497822953120680812L;
    private static Logger logger = Logger.getLogger(BeanHelper.class);

    private boolean compareProperty(Object object1, Object object2, String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object1PropValue = PropertyUtils.getProperty((Object)object1, (String)propertyName);
        Object object2PropValue = PropertyUtils.getProperty((Object)object2, (String)propertyName);
        if (object1PropValue == null) {
            return object2PropValue == null;
        }
        return object1PropValue.equals(object2PropValue);
    }

    public boolean equals(Object other, Object current) {
        if (!current.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        String thisName = current.getClass().getSimpleName();
        String objectName = other.getClass().getSimpleName();
        try {
            for (PropertyDescriptor thisPropertyDescriptor : Introspector.getBeanInfo(current.getClass(), Object.class).getPropertyDescriptors()) {
                ReflectiveOperationException exception = null;
                String propertyName = thisPropertyDescriptor.getName();
                logger.debug((Object)("propertyName=" + propertyName));
                try {
                    if (!this.compareProperty(current, other, propertyName)) {
                        return false;
                    }
                }
                catch (IllegalAccessException e) {
                    exception = e;
                }
                catch (InvocationTargetException e) {
                    exception = e;
                }
                catch (NoSuchMethodException e) {
                    exception = e;
                }
                if (exception == null) continue;
                logger.debug((Object)("impossible to compare property " + propertyName + " for beans " + thisName + " and " + objectName), (Throwable)exception);
            }
        }
        catch (IntrospectionException e) {
            logger.debug((Object)("impossible to get properties for bean " + thisName), (Throwable)e);
        }
        return true;
    }

    public static String toString(Object current) {
        if (current == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer();
        String beanName = current.getClass().getSimpleName();
        buffer.append(beanName);
        buffer.append(" { ");
        Object propertyValue = null;
        boolean first = true;
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(current.getClass(), Object.class).getPropertyDescriptors()) {
                ReflectiveOperationException exception = null;
                String propertyName = propertyDescriptor.getName();
                logger.debug((Object)("propertyName=" + propertyName));
                try {
                    propertyValue = PropertyUtils.getProperty((Object)current, (String)propertyName);
                }
                catch (IllegalAccessException e) {
                    exception = e;
                }
                catch (InvocationTargetException e) {
                    exception = e;
                }
                catch (NoSuchMethodException e) {
                    exception = e;
                }
                if (exception != null) {
                    logger.debug((Object)("impossible to get value of property " + propertyName + " of bean " + beanName), (Throwable)exception);
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(propertyName);
                buffer.append(':');
                buffer.append(propertyValue);
            }
        }
        catch (IntrospectionException e) {
            logger.error((Object)("impossible to get properties of bean " + beanName), (Throwable)e);
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public static Object cloneBean(Object bean) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return BeanUtils.cloneBean((Object)bean);
    }

    public static PropertyDescriptor[] getBeanProperties(Object bean) throws IntrospectionException {
        return Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
    }

    public static Class getBeanPropertyClass(Object bean, String propertyName) throws IntrospectionException {
        PropertyDescriptor[] propDescriptors;
        for (PropertyDescriptor propDescriptor : propDescriptors = BeanHelper.getBeanProperties(bean)) {
            if (!propertyName.equals(propDescriptor.getName())) continue;
            return propDescriptor.getPropertyType();
        }
        return null;
    }
}

