/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.geocoding;

import com.gisgraphy.addressparser.Address;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.addressparser.AddressResultsDto;
import com.gisgraphy.geocoding.GeocodingException;
import com.gisgraphy.geocoding.IGeocodingService;
import com.gisgraphy.rest.BeanToRestParameter;
import com.gisgraphy.rest.IRestClient;
import com.gisgraphy.rest.RestClient;
import com.gisgraphy.serializer.common.OutputFormat;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class GeocodingClient
implements IGeocodingService {
    private String baseUrl;
    IRestClient restClient = new RestClient();

    public GeocodingClient(String baseUrl) {
        if (baseUrl == null || "".equals(baseUrl.trim())) {
            throw new IllegalArgumentException("Geocoding base URL is empty or null");
        }
        try {
            new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("baseurl should be correct");
        }
        this.baseUrl = baseUrl;
    }

    public AddressResultsDto geocode(AddressQuery query) throws GeocodingException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        query.setCallback(null);
        String queryString = BeanToRestParameter.toQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, AddressResultsDto.class, OutputFormat.JSON);
    }

    public void geocodeAndSerialize(AddressQuery query, OutputStream outputStream) throws GeocodingException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("can not serialize to a null outputstream");
        }
        String queryString = BeanToRestParameter.toQueryString(query);
        this.restClient.get(this.baseUrl + queryString, outputStream, query.getFormat());
    }

    public String geocodeToString(AddressQuery query) throws GeocodingException {
        if (query == null) {
            throw new IllegalArgumentException("can not geocode a null query");
        }
        String queryString = BeanToRestParameter.toQueryString(query);
        return this.restClient.get(this.baseUrl + queryString, String.class, query.getFormat());
    }

    public AddressResultsDto geocode(Address address, String countryCode) throws GeocodingException {
        throw new RuntimeException("not implemented !");
    }

    public void setRestClient(IRestClient restClient) {
        this.restClient = restClient;
    }
}

