/*
 * Decompiled with CFR 0.152.
 */
package com.gisgraphy.addressparser.web;

import com.gisgraphy.addressparser.AddressParserException;
import com.gisgraphy.addressparser.AddressQuery;
import com.gisgraphy.domain.valueobject.GisgraphyServiceType;
import com.gisgraphy.helper.OutputFormatHelper;
import com.gisgraphy.serializer.common.OutputFormat;
import javax.servlet.http.HttpServletRequest;

public class AddressQueryHttpBuilder {
    private static AddressQueryHttpBuilder instance = new AddressQueryHttpBuilder();

    public static AddressQueryHttpBuilder getInstance() {
        return instance;
    }

    public AddressQuery buildFromRequest(HttpServletRequest req) {
        String adressParameter = req.getParameter("address");
        if (adressParameter == null || "".equals(adressParameter.trim())) {
            throw new AddressParserException("address is not specified or empty");
        }
        if (adressParameter.length() > 400) {
            throw new AddressParserException("address is limited to 400characters");
        }
        String countryParameter = req.getParameter("country");
        if (countryParameter == null || countryParameter.trim().length() == 0) {
            throw new AddressParserException("country parameter is not specified or empty");
        }
        AddressQuery query = new AddressQuery(adressParameter, countryParameter);
        OutputFormat outputFormat = OutputFormat.getFromString((String)req.getParameter("format"));
        outputFormat = OutputFormatHelper.getDefaultForServiceIfNotSupported(outputFormat, GisgraphyServiceType.ADDRESS_PARSER);
        query.setFormat(outputFormat);
        String callbackParameter = req.getParameter("callback");
        if (callbackParameter != null) {
            query.setCallback(callbackParameter);
        }
        if ("true".equalsIgnoreCase(req.getParameter("indent")) || "on".equalsIgnoreCase(req.getParameter("indent"))) {
            query.setIndent(true);
        }
        if ("true".equalsIgnoreCase(req.getParameter("postal")) || "on".equalsIgnoreCase(req.getParameter("postal"))) {
            query.setPostal(true);
        }
        return query;
    }
}

