/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.topology;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.geotools.geometry.iso.util.algorithm2D.AlgoPoint2D;
import org.geotools.geometry.iso.util.topology.BRepEdge2D;
import org.geotools.geometry.iso.util.topology.BRepFace2D;
import org.geotools.geometry.iso.util.topology.BRepNode2D;

public abstract class Simplex2D
extends BRepFace2D {
    protected BRepNode2D[] node;
    protected Object[] side;

    public abstract int n();

    public abstract byte side(int var1);

    protected Simplex2D(BRepNode2D[] p) {
        int n = this.n();
        this.node = new BRepNode2D[n];
        this.side = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.node[i] = p[i];
        }
    }

    public BRepNode2D[] getNodes() {
        return this.node;
    }

    public BRepNode2D getNode(int s) {
        return this.node[s];
    }

    public Object[] getSides() {
        return this.side;
    }

    public Object getSide(int s) {
        return this.side[s];
    }

    public BRepEdge2D getEdge(int s) {
        return this.isEdgeSide(s) ? (BRepEdge2D)this.side[s] : null;
    }

    public Simplex2D getSimplex(int s) {
        return this.isSimplexSide(s) ? (Simplex2D)this.side[s] : null;
    }

    public boolean isEdgeSide(int i) {
        return this.side[i] instanceof BRepEdge2D;
    }

    public boolean isSimplexSide(int i) {
        return this.side[i] instanceof BRepFace2D;
    }

    public boolean hasNode(BRepNode2D v0) {
        for (int i = 0; i < this.n(); ++i) {
            if (v0 != this.node[i]) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(BRepEdge2D e) {
        for (int i = 0; i < this.n(); ++i) {
            if (this.side[i] != e) continue;
            return true;
        }
        return false;
    }

    public boolean hasFace(BRepFace2D f) {
        int n = this.n();
        for (int i = 0; i < n; ++i) {
            if (!(this.isEdgeSide(i) ? this.getNeighborFace((BRepEdge2D)this.side[i]) == f : this.side[i] == f)) continue;
            return true;
        }
        return false;
    }

    public int getSide(Point2D p0, Point2D p1) {
        int i;
        byte flag = 0;
        for (i = 0; i < this.n(); ++i) {
            if (!p0.equals(this.node[i])) continue;
            flag = (byte)(flag | 1 << i);
            break;
        }
        for (i = 0; i < this.n(); ++i) {
            if (!p1.equals(this.node[i])) continue;
            flag = (byte)(flag | 1 << i);
            break;
        }
        for (i = 0; i < this.n(); ++i) {
            if (flag != this.side(i)) continue;
            return i;
        }
        throw new IllegalArgumentException("error on get_side(GenVertex *v0, GenVertex *v1)");
    }

    public int getSide(BRepEdge2D e) {
        return this.getSide(e.getP1(), e.getP2());
    }

    public int getSide(BRepFace2D f) {
        if (f == this || f == null) {
            throw new IllegalArgumentException("GenSimplex2D f");
        }
        for (int i = 0; i < this.n(); ++i) {
            BRepEdge2D e;
            if (!(this.isSimplexSide(i) ? this.side[i] == f : (e = (BRepEdge2D)this.side[i]) != null && this.getNeighborFace(e) == f)) continue;
            return i;
        }
        return -1;
    }

    public BRepFace2D getNeighborFace(BRepEdge2D e) {
        return e.getSurfaceLeft() == this ? e.getSurfaceRight() : e.getSurfaceLeft();
    }

    public BRepNode2D getNextPoint(BRepNode2D v0, BRepNode2D v1) {
        for (int i = 0; i < this.n(); ++i) {
            if (this.node[i] != v0) continue;
            if (this.node[(i + 1) % this.n()] == v1) {
                return this.node[(i + 2) % this.n()];
            }
            if (this.node[(i + this.n() - 1) % this.n()] == v1) {
                return this.node[(i + this.n() - 2) % this.n()];
            }
            return null;
        }
        return null;
    }

    public ArrayList getAllSimpliciesOnSimplex() {
        ArrayList<Simplex2D> result = new ArrayList<Simplex2D>();
        for (int i = 0; i < this.n(); ++i) {
            Simplex2D simplex = this.getSimplex(i);
            if (simplex == null) continue;
            result.add(simplex);
        }
        return result;
    }

    public ArrayList getAllEdgesOnFace() {
        ArrayList<BRepEdge2D> result = new ArrayList<BRepEdge2D>();
        for (int i = 0; i < this.n(); ++i) {
            BRepEdge2D e = this.getEdge(i);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public ArrayList getAllPointsOnFace() {
        ArrayList<BRepNode2D> result = new ArrayList<BRepNode2D>();
        for (int i = 0; i < this.n(); ++i) {
            result.add(this.node[i]);
        }
        return result;
    }

    public int getOrientation(int s0, int s1) {
        return s0 < s1 || s0 == this.n() && s1 == 0 ? 1 : -1;
    }

    public int getOrientation(Simplex2D f0, Simplex2D f1) {
        int s0 = this.getSide(f0);
        int s1 = this.getSide(f1);
        if (s0 == -1 || s1 == -1) {
            throw new IllegalArgumentException("error on get_side(GenVertex *v0, GenVertex *v1)");
        }
        return this.getOrientation(s0, s1);
    }

    public int getOrientation(Simplex2D f) {
        int s0 = this.getSide(f);
        int s1 = f.getSide(this);
        if (s0 == -1 || s1 == -1) {
            return 0;
        }
        if (this.node[s0] == f.node[s1]) {
            return -1;
        }
        return 1;
    }

    public Point2D getCentroid() {
        Point2D.Double result = new Point2D.Double(this.node[0].getX(), this.node[0].getY());
        int n = this.n();
        for (int i = 1; i < n; ++i) {
            AlgoPoint2D.createAdd(result, this.node[i]);
        }
        return AlgoPoint2D.scale(result, 1.0 / (double)n);
    }

    protected void linkSimplex(int s, Simplex2D f) {
        this.side[s] = f;
    }

    protected void linkEdge(int s, BRepEdge2D e) {
        this.side[s] = e;
    }

    protected void linkEdge(BRepEdge2D e) {
        Point2D p0 = e.getP1();
        Point2D p1 = e.getP2();
        this.linkEdge(this.getSide(p0, p1), e);
    }

    protected void unlinkEdge(int s, BRepEdge2D e) {
        if (this.getEdge(s) != e) {
            throw new IllegalArgumentException("error on unlink_edge");
        }
        this.resetSide(s);
    }

    protected void unlinkEdge(BRepEdge2D e) {
        for (int i = 0; i < this.n(); ++i) {
            if (this.side[i] != e) continue;
            this.resetSide(i);
        }
    }

    protected void swapSide(BRepEdge2D e, Simplex2D f) {
        for (int i = 0; i < this.n(); ++i) {
            if (this.side[i] != e) continue;
            this.side[i] = f;
            return;
        }
    }

    private void resetSide(int s) {
        this.side[s] = null;
    }
}

