/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.index.quadtree;

import org.geotools.geometry.iso.index.quadtree.IntervalSize;
import org.geotools.geometry.iso.index.quadtree.Node;
import org.geotools.geometry.iso.index.quadtree.NodeBase;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.Envelope;
import org.geotools.geometry.iso.util.Assert;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public void insert(Envelope itemEnv, Object item) {
        int index = Root.getSubnodeIndex(itemEnv, origin);
        if (index == -1) {
            this.add(item);
            return;
        }
        Node node = this.subnode[index];
        if (node == null || !node.getEnvelope().contains(itemEnv)) {
            Node largerNode;
            this.subnode[index] = largerNode = Node.createExpanded(node, itemEnv);
        }
        this.insertContained(this.subnode[index], itemEnv, item);
    }

    private void insertContained(Node tree, Envelope itemEnv, Object item) {
        Assert.isTrue(tree.getEnvelope().contains(itemEnv));
        boolean isZeroX = IntervalSize.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        boolean isZeroY = IntervalSize.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        NodeBase node = isZeroX || isZeroY ? tree.find(itemEnv) : tree.getNode(itemEnv);
        node.add(item);
    }

    protected boolean isSearchMatch(Envelope searchEnv) {
        return true;
    }
}

