/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.finder;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.URLUtil;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterface;
import com.opensymphony.xwork2.util.finder.Test;
import com.opensymphony.xwork2.util.finder.UrlSet;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang.xwork.StringUtils;
import org.objectweb.asm.xwork.AnnotationVisitor;
import org.objectweb.asm.xwork.ClassReader;
import org.objectweb.asm.xwork.FieldVisitor;
import org.objectweb.asm.xwork.MethodVisitor;
import org.objectweb.asm.xwork.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private static final Logger LOG = LoggerFactory.getLogger(ClassFinder.class);
    private final Map<String, List<Info>> annotated = new HashMap<String, List<Info>>();
    private final Map<String, ClassInfo> classInfos = new LinkedHashMap<String, ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private boolean extractBaseInterfaces;
    private ClassLoaderInterface classLoaderInterface;

    public ClassFinder(ClassLoaderInterface classLoader) throws Exception {
        this(classLoader, true);
    }

    public ClassFinder(ClassLoaderInterface classLoader, boolean excludeParent) throws Exception {
        this(classLoader, ClassFinder.getUrls(classLoader, excludeParent));
    }

    public ClassFinder(ClassLoaderInterface classLoader, ClassLoaderInterface exclude) throws Exception {
        this(classLoader, ClassFinder.getUrls(classLoader, exclude));
    }

    public ClassFinder(ClassLoaderInterface classLoader, URL url) {
        this(classLoader, Arrays.asList(url));
    }

    public ClassFinder(ClassLoaderInterface classLoader, String ... dirNames) {
        this(classLoader, ClassFinder.getURLs(classLoader, dirNames));
    }

    public ClassFinder(ClassLoaderInterface classLoaderInterface, Collection<URL> urls) {
        this(classLoaderInterface, urls, false);
    }

    public ClassFinder(ClassLoaderInterface classLoaderInterface, Collection<URL> urls, boolean extractBaseInterfaces) {
        this(classLoaderInterface, urls, extractBaseInterfaces, new HashSet(){
            {
                this.add("jar");
            }
        });
    }

    public ClassFinder(ClassLoaderInterface classLoaderInterface, Collection<URL> urls, boolean extractBaseInterfaces, Set<String> protocols) {
        this.classLoaderInterface = classLoaderInterface;
        this.extractBaseInterfaces = extractBaseInterfaces;
        ArrayList<String> classNames = new ArrayList<String>();
        for (URL location : urls) {
            try {
                if (protocols.contains(location.getProtocol())) {
                    classNames.addAll(this.jar(location));
                    continue;
                }
                if (!"file".equals(location.getProtocol())) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(this.jar(jarUrl));
                }
                catch (IOException e) {
                    classNames.addAll(this.file(location));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Unable to read URL [#0]", e, location.toExternalForm());
            }
        }
        for (String className : classNames) {
            try {
                this.readClassDef(className);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Unable to read class [#0]", e, className);
            }
        }
    }

    public ClassFinder(Class ... classes) {
        this(Arrays.asList(classes));
    }

    public ClassFinder(List<Class> classes) {
        this.classLoaderInterface = null;
        ArrayList<Annotatable> infos = new ArrayList<Annotatable>();
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Class clazz : classes) {
            Package aPackage = clazz.getPackage();
            if (aPackage != null && !packages.contains(aPackage)) {
                infos.add(new PackageInfo(aPackage));
                packages.add(aPackage);
            }
            ClassInfo classInfo = new ClassInfo(clazz);
            infos.add(classInfo);
            this.classInfos.put(classInfo.getName(), classInfo);
            for (Method method : clazz.getDeclaredMethods()) {
                infos.add(new MethodInfo(classInfo, method));
            }
            for (Executable executable : clazz.getConstructors()) {
                infos.add(new MethodInfo(classInfo, (Constructor)executable));
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                infos.add(new FieldInfo(classInfo, (Field)accessibleObject));
            }
        }
        for (Info info : infos) {
            for (AnnotationInfo annotation : info.getAnnotations()) {
                List<Info> annotationInfos = this.getAnnotationInfos(annotation.getName());
                annotationInfos.add(info);
            }
        }
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    public List<Class> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                Class clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || "<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || !"<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            FieldInfo fieldInfo;
            ClassInfo classInfo;
            if (!(info instanceof FieldInfo) || seen.contains(classInfo = (fieldInfo = (FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    public List<Class> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class> findClasses(Test<ClassInfo> test) {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (!test.test(classInfo)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class> findClasses() {
        this.classesNotLoaded.clear();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error loading class [#0]", e, classInfo.getName());
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    private static List<URL> getURLs(ClassLoaderInterface classLoader, String[] dirNames) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String dirName : dirNames) {
            try {
                Enumeration<URL> classLoaderURLs = classLoader.getResources(dirName);
                while (classLoaderURLs.hasMoreElements()) {
                    URL url = classLoaderURLs.nextElement();
                    urls.add(url);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Could not read driectory [#0]", ioe, dirName);
            }
        }
        return urls;
    }

    private static Collection<URL> getUrls(ClassLoaderInterface classLoaderInterface, boolean excludeParent) throws IOException {
        return ClassFinder.getUrls(classLoaderInterface, excludeParent ? classLoaderInterface.getParent() : null);
    }

    private static Collection<URL> getUrls(ClassLoaderInterface classLoader, ClassLoaderInterface excludeParent) throws IOException {
        UrlSet urlSet = new UrlSet(classLoader);
        if (excludeParent != null) {
            urlSet = urlSet.exclude(excludeParent);
        }
        return urlSet.getUrls();
    }

    private List<String> file(URL location) {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath()));
        if ("META-INF".equals(dir.getName())) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, "");
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            name = name.replaceFirst(".class$", "");
            classNames.add(packageName + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> jar(URL location) throws IOException {
        URL url = URLUtil.normalizeToFileProtocol(location);
        if (url != null) {
            InputStream in = url.openStream();
            try {
                JarInputStream jarStream = new JarInputStream(in);
                List<String> list = this.jar(jarStream);
                return list;
            }
            finally {
                in.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to read [#0]", location.toExternalForm());
        }
        return Collections.emptyList();
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName();
            className = className.replaceFirst(".class$", "");
            className = StringUtils.removeStart(className, "WEB-INF/classes/");
            className = className.replace('/', '.');
            classNames.add(className);
        }
        return classNames;
    }

    private List<Info> getAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new ArrayList<Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassDef(String className) {
        block7: {
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.classLoaderInterface.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    try {
                        ClassReader classReader = new ClassReader(in);
                        classReader.accept(new InfoBuildingVisitor(), 2);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new XWorkException("Could not load " + className);
            }
            catch (IOException e) {
                throw new XWorkException("Could not load " + className, e);
            }
        }
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private Info info;

        public InfoBuildingVisitor() {
        }

        public InfoBuildingVisitor(Info info) {
            this.info = info;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(this.javaName(name));
            } else {
                ClassInfo classInfo = new ClassInfo(this.javaName(name), this.javaName(superName));
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(this.javaName(interfce));
                }
                this.info = classInfo;
                ClassFinder.this.classInfos.put(classInfo.getName(), classInfo);
                if (ClassFinder.this.extractBaseInterfaces) {
                    this.extractSuperInterfaces(classInfo);
                }
            }
        }

        private void extractSuperInterfaces(ClassInfo classInfo) {
            String superType = classInfo.getSuperType();
            if (superType != null) {
                ClassInfo base = (ClassInfo)ClassFinder.this.classInfos.get(superType);
                if (base == null) {
                    String resource = superType.replace('.', '/') + ".class";
                    ClassFinder.this.readClassDef(resource);
                    base = (ClassInfo)ClassFinder.this.classInfos.get(superType);
                }
                if (base != null) {
                    List<String> interfaces = classInfo.getSuperInterfaces();
                    interfaces.addAll(base.getSuperInterfaces());
                    interfaces.addAll(base.getInterfaces());
                }
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            ClassFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return new InfoBuildingVisitor(annotationInfo);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassInfo classInfo = (ClassInfo)this.info;
            FieldInfo fieldInfo = new FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassInfo classInfo = (ClassInfo)this.info;
            MethodInfo methodInfo = new MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo);
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            MethodInfo methodInfo = (MethodInfo)this.info;
            List<AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationInfo
    extends Annotatable
    implements Info {
        private final String name;

        public AnnotationInfo(Annotation annotation) {
            this(annotation.getClass().getName());
        }

        public AnnotationInfo(Class<? extends Annotation> annotation) {
            this.name = annotation.getName().intern();
        }

        public AnnotationInfo(String name) {
            name = name.replaceAll("^L|;$", "");
            name = name.replace('/', '.');
            this.name = name.intern();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class FieldInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final String type;
        private final ClassInfo declaringClass;

        public FieldInfo(ClassInfo info, Field field) {
            super(field);
            this.declaringClass = info;
            this.name = field.getName();
            this.type = field.getType().getName();
        }

        public FieldInfo(ClassInfo declaringClass, String name, String type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.declaringClass + "#" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInfo
    extends Annotatable
    implements Info {
        private final ClassInfo declaringClass;
        private final String returnType;
        private final String name;
        private final List<List<AnnotationInfo>> parameterAnnotations;

        public MethodInfo(ClassInfo info, Constructor constructor) {
            super(constructor);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = "<init>";
            this.returnType = Void.TYPE.getName();
        }

        public MethodInfo(ClassInfo info, Method method) {
            super(method);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = method.getName();
            this.returnType = method.getReturnType().getName();
        }

        public MethodInfo(ClassInfo declarignClass, String name, String returnType) {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = declarignClass;
            this.name = name;
            this.returnType = returnType;
        }

        public List<List<AnnotationInfo>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public List<AnnotationInfo> getParameterAnnotations(int index) {
            if (index >= this.parameterAnnotations.size()) {
                for (int i = this.parameterAnnotations.size(); i <= index; ++i) {
                    ArrayList annotationInfos = new ArrayList();
                    this.parameterAnnotations.add(i, annotationInfos);
                }
            }
            return this.parameterAnnotations.get(index);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.declaringClass + "@" + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final List<MethodInfo> methods;
        private final List<MethodInfo> constructors;
        private final String superType;
        private final List<String> interfaces;
        private final List<String> superInterfaces;
        private final List<FieldInfo> fields;
        private Class<?> clazz;
        private ClassNotFoundException notFound;

        public ClassInfo(Class clazz) {
            super(clazz);
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.superInterfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.clazz = clazz;
            this.name = clazz.getName();
            Class superclass = clazz.getSuperclass();
            this.superType = superclass != null ? superclass.getName() : null;
        }

        public ClassInfo(String name, String superType) {
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.superInterfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.name = name;
            this.superType = superType;
        }

        public String getPackageName() {
            return this.name.indexOf(".") > 0 ? this.name.substring(0, this.name.lastIndexOf(".")) : "";
        }

        public List<MethodInfo> getConstructors() {
            return this.constructors;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }

        public List<String> getSuperInterfaces() {
            return this.superInterfaces;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<MethodInfo> getMethods() {
            return this.methods;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getSuperType() {
            return this.superType;
        }

        public Class get() throws ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            if (this.notFound != null) {
                throw this.notFound;
            }
            try {
                this.clazz = ClassFinder.this.classLoaderInterface.loadClass(this.name);
                return this.clazz;
            }
            catch (ClassNotFoundException notFound) {
                ClassFinder.this.classesNotLoaded.add(this.name);
                this.notFound = notFound;
                throw notFound;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public class PackageInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name) {
            this.info = new ClassInfo(name, null);
            this.name = name;
            this.pkg = null;
        }

        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Info {
        public String getName();

        public List<AnnotationInfo> getAnnotations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Annotatable {
        private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

        public Annotatable(AnnotatedElement element) {
            for (Annotation annotation : element.getAnnotations()) {
                this.annotations.add(new AnnotationInfo(annotation.annotationType().getName()));
            }
        }

        public Annotatable() {
        }

        public List<AnnotationInfo> getAnnotations() {
            return this.annotations;
        }
    }
}

